% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_select.R
\name{marker_select}
\alias{marker_select}
\alias{selectMarkers}
\alias{getMarkers}
\alias{removeMarkers}
\alias{whichMarkers}
\title{Select or remove attached markers}
\usage{
selectMarkers(x, markers = NULL, chroms = NULL, fromPos = NULL,
  toPos = NULL)

getMarkers(x, markers = NULL, chroms = NULL, fromPos = NULL,
  toPos = NULL)

removeMarkers(x, markers = NULL, chroms = NULL, fromPos = NULL,
  toPos = NULL)

whichMarkers(x, markers = NULL, chroms = NULL, fromPos = NULL,
  toPos = NULL)
}
\arguments{
\item{x}{A \code{ped} object}

\item{markers}{Either a character vector (with marker names), a numeric
vector (with marker indices), or NULL}

\item{chroms}{A vector of chromosome names, or NULL}

\item{fromPos}{A single number or NULL}

\item{toPos}{A single number or NULL}
}
\value{
The return values of these functions are:
\itemize{
\item \code{selectMarkers()} : a \code{ped} object where only the indicated markers are kept
\item \code{removeMarkers()} : a \code{ped} object where the indicated markers are removed
\item \code{getMarkers()} : a list of \code{marker} objects
\item \code{whichMarkers()} : an integer vector with indices of the indicated markers
}
}
\description{
Functions for manipulating markers attached to a \code{ped} object.
}
\seealso{
\code{\link[=setMarkers]{setMarkers()}}
}
