% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_round.r
\docType{methods}
\name{rounding}
\alias{ceiling,ddmatrix-method}
\alias{floor,ddmatrix-method}
\alias{round,ddmatrix-method}
\alias{rounding}
\title{Rounding of Numbers}
\usage{
\S4method{round}{ddmatrix}(x, digits = 0)

\S4method{ceiling}{ddmatrix}(x)

\S4method{floor}{ddmatrix}(x)
}
\arguments{
\item{x}{numeric distributed matrix}

\item{digits}{integer indicating the number of decimal places
(\code{round()}) or significant digits (\code{signif()}) to be used.
Negative values are allowed (see 'Details').}
}
\value{
Returns a distributed matrix.
}
\description{
Extensions of R rounding functions for distributed matrices.
}
\details{
Rounding to a negative number of digits means rounding to a power of ten, so
for example \code{round(x, digits = -2)} rounds to the nearest hundred.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:9, 3)
x <- as.ddmatrix(x)

y <- ceiling(x/3)
print(y)

finalize()
}

}
\keyword{Methods}

