% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.vector.r
\docType{methods}
\name{as.vector}
\alias{as.vector}
\alias{as.vector,ddmatrix-method}
\title{Distributed object to Vector Converters}
\usage{
as.vector(x, ...)

\S4method{as.vector}{ddmatrix}(x, mode = "any", proc.dest = "all")
}
\arguments{
\item{x}{numeric distributed matrix}

\item{...}{Additional arguments.}

\item{mode}{A character string giving an atomic mode or "list", or (except
for 'vector') "any".}

\item{proc.dest}{destination process for storing the matrix}
}
\value{
Returns an ordinary R vector.
}
\description{
Converts a distributed matrix into a non-distributed vector.
}
\details{
The \code{proc.dest=} argument accepts either the BLACS grid position or the
MPI rank if the user desires a single process to own the matrix.
Alternatively, passing the default value of \code{'all'} will result in all
processes owning the matrix. If only a single process owns the undistributed
matrix, then all other processes store \code{NULL} for that object.
}
\examples{

\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

dx <- ddmatrix(1:16, ncol=4, bldim=2)
y <- as.vector(dx, proc.dest=0)

comm.print(y)

finalize()
}

}
\keyword{Methods}

