% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/panel_loglik.R
\name{panel_loglik}
\alias{panel_loglik}
\alias{logLik,matrix-method}
\title{Handling of loglikelihood replicates}
\usage{
\S4method{logLik}{matrix}(object, repMargin, first = "aver", aver = "logmeanexp", se = FALSE)
}
\arguments{
\item{object}{Matrix with the same number of replicated estimates for each
panel unit loglikelihood.}

\item{repMargin}{The margin of the matrix having the replicates (1 for rows,
2 for columns).}

\item{first}{Wether to \code{"aver"}(age replicates) or \code{"aggr"}(egate
units) before performing the other action.}

\item{aver}{How to average: \code{'logmeanexp'} to average on the likelihood
scale before taking logs or \code{'mean'} to average after taking logs (in
which case, which action is performed first does not change the result).}

\item{se}{logical; whether to give standard errors.}
}
\value{
\code{numeric} vector with the average panel log likelihood and, when
\code{se = TRUE}, the corresponding standard error.
}
\description{
Handling of loglikelihood replicates.
}
\details{
When \code{se = TRUE}, the jackknife se's from
\code{pomp::logmeanexp} are squared, summed and the squared root is taken.
}
\examples{
ulls <- matrix(c(1,1.1,10.1,10),nr=2)
# when combining log likelihood estimates, the order in which aggregation and
# averaging are done can make a difference: panel_logmeanexp() implements the best
logLik(ulls,repMargin=1,first="aver",aver="logmeanexp")
logLik(ulls,repMargin=1,first="aggr",aver="mean",se=TRUE)
}
\seealso{
Other panelPomp workhorse functions: 
\code{\link{mif2}()},
\code{\link{panelPomp}},
\code{\link{pfilter}()}
}
\author{
Carles \Breto
}
\concept{panelPomp workhorse functions}
