% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{palasso}
\alias{palasso}
\title{Paired lasso}
\usage{
palasso(y, X, max = 10, ...)
}
\arguments{
\item{y}{response\strong{:}
vector of length \eqn{n}}

\item{X}{covariates\strong{:}
list of matrices,
each with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{max}{maximum number of non-zero coefficients\strong{:}
positive numeric, or \code{NULL} \eqn{(no sparsity constraint)}}

\item{...}{further arguments for \code{\link[glmnet]{cv.glmnet}} or
\code{\link[glmnet]{glmnet}}}
}
\value{
This function returns an object of class \code{palasso}.
Available methods include
\code{\link[=predict.palasso]{predict}},
\code{\link[=coef.palasso]{coef}},
\code{\link[=weights.palasso]{weights}},
\code{\link[=fitted.palasso]{fitted}},
\code{\link[=residuals.palasso]{residuals}},
\code{\link[=deviance.palasso]{deviance}},
\code{\link[=logLik.palasso]{logLik}},
and \code{\link[=summary.palasso]{summary}}.
}
\description{
The function \code{palasso} fits the paired lasso. Use this function if you
have \emph{paired covariates} and want a \emph{sparse model}.
}
\details{
Let \code{x} denote one entry of the list \code{X}. See \link[glmnet]{glmnet}
for alternative specifications of \code{y} and \code{x}. Among the further
arguments, \code{family} must equal \code{"gaussian"}, \code{"binomial"},
\code{"poisson"}, or \code{"cox"}, and \code{penalty.factor} must not be
used. Fit additional lasso models by setting the hidden argument
\code{standard} to \code{TRUE}.
}
\examples{
set.seed(1)
n <- 50; p <- 20
y <- rbinom(n=n,size=1,prob=0.5)
X <- lapply(1:2,function(x) matrix(rnorm(n*p),nrow=n,ncol=p))
object <- palasso(y=y,X=X,family="binomial")

}
\references{
A Rauschenberger, RX Menezes, MA Jonker, and MA van de Wiel (2018).
"Sparse regression with paired covariates."
\emph{Manuscript in preparation.} \email{a.rauschenberger@vumc.nl}
}
