% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{overlayPlotOutput}
\alias{overlayPlotOutput}
\title{Create a plot output element with overlays}
\usage{
overlayPlotOutput(outputId, width, height)
}
\arguments{
\item{outputId}{The \code{output} slot where the plot will be rendered using
\code{\link[shiny:renderPlot]{shiny::renderPlot()}}, with a call to \code{\link[=overlayBounds]{overlayBounds()}}.}

\item{width, height}{Image width and height. Must be a valid CSS unit, like
\code{"100\%"}, \code{"400px"}, or \code{"auto"}, or a number, interpreted as pixels.}
}
\value{
A plot output element that can be added to a UI definition.
}
\description{
Render a \code{\link[shiny:renderPlot]{shiny::renderPlot()}} within an application page, with support for
overlays.
}
\examples{
ui <- shiny::fluidPage(
    useOverlay(),
    overlayPlotOutput("my_plot", 640, 480)
    # further UI elements here . . .
)

}
\seealso{
\code{\link[=overlayServer]{overlayServer()}}, for a complete example.
}
