% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-noop.R
\name{otel_meter_provider}
\alias{otel_meter_provider}
\title{OpenTelemetry meter provider objects}
\value{
Not applicable.
}
\description{
\link{otel_meter_provider} -> \link{otel_meter} -> \link{otel_counter},
\link{otel_up_down_counter}, \link{otel_histogram}, \link{otel_gauge}
}
\details{
The meter provider defines how metrics are exported when collecting
telemetry data. It is unlikely that you need to use meter provider
objects directly.

Usually there is a single meter provider for an R app or script.

Typically the meter provider is created automatically, at the first
\code{\link[=counter_add]{counter_add()}}, \code{\link[=up_down_counter_add]{up_down_counter_add()}}, \code{\link[=histogram_record]{histogram_record()}},
\code{\link[=gauge_record]{gauge_record()}} or \code{\link[=get_meter]{get_meter()}} call. otel decides which meter
provider class to use based on \link{Environment Variables}.
}
\section{Implementations}{
Note that this list is updated manually and may be incomplete.
\itemize{
\item \link{meter_provider_noop}: No-op meter provider, used when no metrics are
emitted.
\item \link[otelsdk:meter_provider_file]{otelsdk::meter_provider_file}: Save metrics to a JSONL file.
\item \link[otelsdk:meter_provider_http]{otelsdk::meter_provider_http}: Send metrics to a collector over
HTTP/OTLP.
\item \link[otelsdk:meter_provider_memory]{otelsdk::meter_provider_memory}: Collect emitted metrics in memory.
For testing.
\item \link[otelsdk:meter_provider_stdstream]{otelsdk::meter_provider_stdstream}: Write metrics to standard output
or error or to a file. Primarily for debugging.
}
}

\section{Methods}{
\subsection{\code{meter_provider$get_meter()}}{

Get or create a new meter object.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{meter_provider$get_meter(
  name = NULL,
  version = NULL,
  schema_url = NULL,
  attributes = NULL
)
}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\itemize{
\item \code{name}: Meter name, see \code{\link[=get_meter]{get_meter()}}.
\item \code{version}: Optional. Specifies the version of the instrumentation
scope if the scope has a version (e.g. R package version).
Example value: \code{"1.0.0"}.
\item \code{schema_url}: Optional. Specifies the Schema URL that should be
recorded in the emitted telemetry.
\item \code{attributes}: Optional. Specifies the instrumentation scope
attributes to associate with emitted telemetry. See \code{\link[=as_attributes]{as_attributes()}}
for allowed values. You can also use \code{\link[=as_attributes]{as_attributes()}} to convert R
objects to OpenTelemetry attributes.
}
}

\subsection{Value}{

Returns an OpenTelemetry meter (\link{otel_meter}) object.
}

\subsection{See also}{

\code{\link[=get_default_meter_provider]{get_default_meter_provider()}}, \code{\link[=get_meter]{get_meter()}}.
}

}

\subsection{\code{meter_provider$flush()}}{

Force any buffered metrics to flush. Meter providers might not implement
this method.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{meter_provider$flush()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Nothing.
}

}

\subsection{\code{meter_provider$shutdown()}}{

Stop the meter provider. Stops collecting and emitting measurements.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{meter_provider$shurdown()
}\if{html}{\out{</div>}}
}

\subsection{Value}{

Nothing
}

}
}

\examples{
mp <- otel::get_default_meter_provider()
mtr <- mp$get_meter()
mtr$is_enabled()
}
\seealso{
Other low level metrics API: 
\code{\link{get_default_meter_provider}()},
\code{\link{get_meter}()},
\code{\link{meter_provider_noop}},
\code{\link{otel_counter}},
\code{\link{otel_gauge}},
\code{\link{otel_histogram}},
\code{\link{otel_meter}},
\code{\link{otel_up_down_counter}}
}
\concept{low level metrics API}
