% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwasCredibleSet.R
\name{gwasCredibleSet}
\alias{gwasCredibleSet}
\title{Retrieve GWAS credible set data}
\usage{
gwasCredibleSet(study_id, variant_id)
}
\arguments{
\item{study_id}{Character: Study ID(s) generated by Open Targets Genetics (e.g GCST90002357).}

\item{variant_id}{Character: generated ID for variants by Open Targets Genetics (e.g. 1_154119580_C_A) or rsId (rs2494663).}
}
\value{
Returns a data frame of results from the credible set of variants for a specific lead variant with the following columns:
\itemize{
  \item{\code{tagVariant.id}:} \emph{Data frame}. A table of IDs of the tag variant.
  \item{\code{tagVariant.rsId}:} \emph{Character vector}. rsID of the tag variant.
  \item{\code{beta}:} \emph{Numeric}. Beta value.
  \item{\code{postProb}:} \emph{Numeric}. Posterior probability.
  \item{\code{pval}:} \emph{Numeric}. P-value.
  \item{\code{se}:} \emph{Numeric}. Standard error.
  \item{\code{MultisignalMethod}:} \emph{Character vector}. Multisignal method.
  \item{\code{logABF}:} \emph{Numeric}. Logarithm of approximate Bayes factor.
  \item{\code{is95}:} \emph{Logical}. Indicates if the variant has a 95% credible set.
  \item{\code{is99}:} \emph{Logical}. Indicates if the variant has a 99% credible set.
}
}
\description{
Provided with a study ID and a lead variant ID, this function returns a
data frame consisting of all the associated credible set tag variants
 with the corresponding statistical data.
}
\examples{
\dontrun{
result <- gwasCredibleSet(study_id="GCST90002357", variant_id="1_154119580_C_A")
result <- gwasCredibleSet(study_id="GCST90002357", variant_id="rs2494663")
}
}
