% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_extract.R
\name{osrm_extract}
\alias{osrm_extract}
\title{Extract OSM into OSRM Graph Files}
\usage{
osrm_extract(
  input_osm,
  profile = osrm_find_profile("car.lua"),
  threads = 8L,
  overwrite = FALSE,
  verbosity = c("INFO", "NONE", "ERROR", "WARNING", "DEBUG"),
  data_version = NULL,
  small_component_size = 1000L,
  with_osm_metadata = FALSE,
  parse_conditional_restrictions = FALSE,
  location_dependent_data = NULL,
  disable_location_cache = FALSE,
  dump_nbg_graph = FALSE,
  quiet = FALSE,
  verbose = FALSE,
  spinner = TRUE,
  echo_cmd = FALSE
)
}
\arguments{
\item{input_osm}{A string. Path to the input OSM file
(\code{.osm}, \code{.osm.bz2}, or \code{.osm.pbf}) or a directory containing exactly one
OSM file with a supported extension.}

\item{profile}{A string. Path to the OSRM Lua profile
(e.g. returned by \code{osrm_find_profile("car.lua")}).}

\item{threads}{An integer. Number of threads for
\code{-t/--threads}; default \code{8} (OSRM's default).}

\item{overwrite}{A logical. If \code{FALSE} (default), stops when any
existing \verb{.osrm*} files matching the base name are found alongside
\code{input_osm}. Set to \code{TRUE} to proceed regardless.}

\item{verbosity}{A string. Log verbosity level passed to
\code{-l/--verbosity} (one of \code{"NONE","ERROR","WARNING","INFO","DEBUG"}),
default \code{"INFO"}.}

\item{data_version}{A string or \code{NULL}. Passed to
\code{-d/--data_version}; default \code{NULL}, in which case the option
is omitted.}

\item{small_component_size}{An integer. For
\code{--small-component-size}; default \code{1000} (OSRM's default).}

\item{with_osm_metadata}{A logical. If \code{TRUE}, adds
\code{--with-osm-metadata}; default \code{FALSE}.}

\item{parse_conditional_restrictions}{A logical. If \code{TRUE}, adds
\code{--parse-conditional-restrictions}; default \code{FALSE}.}

\item{location_dependent_data}{A string or \code{NULL}. Path to GeoJSON,
passed to \code{--location-dependent-data}; default \code{NULL}, in which
case the option is omitted.}

\item{disable_location_cache}{A logical. If \code{TRUE}, adds
\code{--disable-location-cache}; default \code{FALSE}.}

\item{dump_nbg_graph}{A logical. If \code{TRUE}, adds
\code{--dump-nbg-graph}; default \code{FALSE}.}

\item{quiet}{A logical. Master switch that suppresses package messages and
process output when \code{TRUE}; default \code{FALSE}.}

\item{verbose}{A logical. When \code{TRUE} and \code{quiet = FALSE}, streams stdout and
stderr from the underlying \code{processx::run} calls.}

\item{spinner}{A logical. When \code{TRUE} and \code{quiet = FALSE}, shows a spinner
instead of live logs; default \code{TRUE}.}

\item{echo_cmd}{A logical. When \code{TRUE} and \code{quiet = FALSE}, prints each
command before running; default \code{FALSE}.}
}
\value{
An object of class \code{osrm_job} with the following elements:
\describe{
\item{osrm_job_artifact}{The path to the generated \code{.osrm.timestamp} file.}
\item{osrm_working_dir}{The directory containing all OSRM files.}
\item{logs}{The \code{processx::run} result object.}
}
}
\description{
Run the \code{osrm-extract} tool to preprocess an OSM file
(\code{.osm}, \code{.osm.bz2}, or \code{.osm.pbf}) into the base \code{.osrm} graph files
using a specified Lua profile.  After running, a companion
\verb{<base>.osrm.timestamp} file must exist to confirm success.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  # Install OSRM (temporary, session PATH)
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # copy example OSM PBF into a temporary workspace to avoid polluting pkg data
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)

  # Find the path to the profile first
  car_profile <- osrm_find_profile("car.lua")

  # extract OSRM graph files
  result <- osrm_extract(
    input_osm                  = tmp_pbf,
    profile                    = car_profile,
    overwrite                  = TRUE,
    threads                    = 1L
  )
  # path to generated .osrm files (specifically, the .osrm.timestamp file)
  result$osrm_job_artifact

  # Clean up binaries and workspace
  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}
}
