% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm_query_changesets.R
\name{osm_query_changesets}
\alias{osm_query_changesets}
\title{Query changesets}
\usage{
osm_query_changesets(
  bbox,
  user,
  time,
  time_2,
  from,
  to,
  open,
  closed,
  changeset_ids,
  order = c("newest", "oldest"),
  limit = getOption("osmapir.api_capabilities")$api$changesets["default_query_limit"],
  format = c("R", "sf", "xml", "json"),
  tags_in_columns = FALSE
)
}
\arguments{
\item{bbox}{Find changesets within the given bounding box coordinates (\verb{left,bottom,right,top}).}

\item{user}{Find changesets by the user with the given user id (numeric) or display name (character).}

\item{time}{Find changesets \strong{closed} after this date and time. See details for the valid formats.}

\item{time_2}{find changesets that were \strong{closed} after \code{time} and \strong{created} before \code{time_2}. In other words, any
changesets that were open \strong{at some time} during the given time range \code{time} to \code{time_2}.  See details for the
valid formats.}

\item{from}{Find changesets \strong{created} at or after this value. See details for the valid formats.}

\item{to}{Find changesets \strong{created} before this value. \code{to} requires \code{from}, but not vice-versa. If \code{to} is
provided alone, it has no effect. See details for the valid formats.}

\item{open}{If \code{TRUE}, only finds changesets that are still \strong{open} but excludes changesets that are closed or have
reached the element limit for a changeset (10,000 at the moment \code{osm_capabilities()$api$changesets}).}

\item{closed}{If \code{TRUE}, only finds changesets that are \strong{closed} or have reached the element limit.}

\item{changeset_ids}{Finds changesets with the specified ids.}

\item{order}{If \code{"newest"} (default), sort newest changesets first. If \code{"oldest"}, reverse order.}

\item{limit}{Specifies the maximum number of changesets returned. 100 as the default value.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"sf"}, \code{"xml"}, or \code{"json"}.}

\item{tags_in_columns}{If \code{FALSE} (default), the tags of the changesets are saved in a single list column \code{tags}
containing a \code{data.frame} for each changeset with the keys and values. If \code{TRUE}, add a column for each key.
Ignored if \code{format != "R"}.}
}
\value{
If \code{format = "R"}, returns a data frame with one OSM changeset per row. If \code{format = "sf"}, returns a \code{sf} object
from \pkg{sf}.
\subsection{\code{format = "xml"}}{

Returns a \link[xml2:oldclass]{xml2::xml_document} with the following format:

\if{html}{\out{<div class="sourceCode xml">}}\preformatted{<osm version="0.6" generator="OpenStreetMap server" copyright="OpenStreetMap and contributors" attribution="http://www.openstreetmap.org/copyright" license="http://opendatacommons.org/licenses/odbl/1-0/">
  <changeset id="10" created_at="2005-05-01T16:09:37Z" open="false" comments_count="1" changes_count="10" closed_at="2005-05-01T17:16:44Z" min_lat="59.9513092" min_lon="10.7719727" max_lat="59.9561501" max_lon="10.7994537" uid="24" user="Petter Reinholdtsen">
    <tag k="created_by" v="JOSM 1.61"/>
    <tag k="comment" v="Just adding some streetnames"/>
    ...
  </changeset>
  <changeset ...>
    ...
  </changeset>
</osm>
}\if{html}{\out{</div>}}
}

\subsection{\code{format = "json"}}{

\emph{Please note that the JSON format has changed on August 25, 2024 with the release of openstreetmap-cgimap 2.0.0, to}
\emph{align it with the existing Rails format.}

Returns a list with the following json structure:

\if{html}{\out{<div class="sourceCode json">}}\preformatted{\{
  "version": "0.6",
  "generator": "openstreetmap-cgimap 2.0.0 (4003517 spike-08.openstreetmap.org)",
  "copyright": "OpenStreetMap and contributors",
  "attribution": "http://www.openstreetmap.org/copyright",
  "license": "http://opendatacommons.org/licenses/odbl/1-0/",
  "changesets": [
    \{
      "id": 10,
      "created_at": "2005-05-01T16:09:37Z",
      "open": false,
      "comments_count": 1,
      "changes_count": 10,
      "closed_at": "2005-05-01T17:16:44Z",
      "min_lat": 59.9513092,
      "min_lon": 10.7719727,
      "max_lat": 59.9561501,
      "max_lon": 10.7994537,
      "uid": 24,
      "user": "Petter Reinholdtsen",
      "tags": \{
          "comment": "Just adding some streetnames",
          "created_by": "JOSM 1.61"
      \}
    \},
    ...
  ]
\}
}\if{html}{\out{</div>}}
}
}
\description{
This is an API method for querying changesets. It supports querying by different criteria.
}
\details{
Where multiple queries are given the result will be those which match all of the requirements. The contents of the
returned document are the changesets and their tags. To get the full set of changes associated with a changeset, use
\code{\link[=osm_download_changeset]{osm_download_changeset()}} on each changeset ID individually.

Modification and extension of the basic queries above may be required to support rollback and other uses we find for
changesets.

This call returns latest changesets matching criteria. The default ordering is newest first, but you can specify
\code{order = "oldest"} to reverse the sort order (see
\href{https://github.com/openstreetmap/openstreetmap-website/blob/f1c6a87aa137c11d0aff5a4b0e563ac2c2a8f82d/app/controllers/api/changesets_controller.rb#L174}{ordered by \code{created_at}}
– see the \href{https://github.com/openstreetmap/openstreetmap-website/blob/master/app/controllers/api/changesets_controller.rb#L174}{current state}).
Reverse ordering cannot be combined with \code{time}.

Te valid formats for \code{time}, \code{time_2}, \code{from} and \code{to} parameters are \link{POSIXt} values or characters with anything
that \href{https://ruby-doc.org/stdlib-2.7.0/libdoc/time/rdoc/Time.html#method-c-parse}{\code{Time.parse} Ruby function} will
parse.
}
\examples{
chst_ids <- osm_query_changesets(changeset_ids = c(137627129, 137625624))
chst_ids

chsts <- osm_query_changesets(
  bbox = c(-1.241112, 38.0294955, 8.4203171, 42.9186456),
  user = "Mementomoristultus",
  time = "2023-06-22T02:23:23Z",
  time_2 = "2023-06-22T00:38:20Z"
)
chsts

chsts2 <- osm_query_changesets(
  bbox = c("-9.3015367,41.8073642,-6.7339533,43.790422"),
  user = "Mementomoristultus",
  closed = TRUE
)
chsts2
}
\seealso{
Other get changesets' functions: 
\code{\link{osm_download_changeset}()},
\code{\link{osm_get_changesets}()}
}
\concept{get changesets' functions}
