% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-factanal.r
\name{methods-factanal}
\alias{methods-factanal}
\alias{as_tbl_ord.factanal}
\alias{recover_rows.factanal}
\alias{recover_cols.factanal}
\alias{recover_inertia.factanal}
\alias{recover_coord.factanal}
\alias{recover_conference.factanal}
\alias{recover_supp_rows.factanal}
\alias{recover_aug_rows.factanal}
\alias{recover_aug_cols.factanal}
\alias{recover_aug_coord.factanal}
\title{Functionality for factor analysis ('factanal') objects}
\usage{
\method{as_tbl_ord}{factanal}(x)

\method{recover_rows}{factanal}(x)

\method{recover_cols}{factanal}(x)

\method{recover_inertia}{factanal}(x)

\method{recover_coord}{factanal}(x)

\method{recover_conference}{factanal}(x)

\method{recover_supp_rows}{factanal}(x)

\method{recover_aug_rows}{factanal}(x)

\method{recover_aug_cols}{factanal}(x)

\method{recover_aug_coord}{factanal}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"factanal"} as returned by \code{\link[stats:factanal]{stats::factanal()}}.
}
\details{
Factor analysis of a data matrix relies on an an eigendecomposition of its
correlation matrix, whose eigenvectors (up to weighting) comprise the
variable loadings. For this reason, both row and column recoverers retrieve
the loadings and inertia is evenly distributed between them. When computed
and returned by \code{\link[stats:factanal]{stats::factanal()}}, the case scores are accessible as
supplementary elements. Redistribution of inertia commutes through both
score calculations.
}
\examples{
# data frame of Swiss fertility and socioeconomic indicators
class(swiss)
head(swiss)
# perform factor analysis
swiss_fa <- factanal(~ ., factors = 2L, data = swiss, scores = "regression")

# wrap as a 'tbl_ord' object
(swiss_fa <- as_tbl_ord(swiss_fa))

# recover loadings
get_rows(swiss_fa, elements = "active")
get_cols(swiss_fa)
# recover scores
head(get_rows(swiss_fa, elements = "score"))

# augment column loadings with uniquenesses
(swiss_fa <- augment_ord(swiss_fa))

# symmetric biplot
swiss_fa \%>\%
  ggbiplot() +
  theme_bw() +
  geom_cols_vector(aes(color = uniqueness)) +
  geom_cols_text_radiate(aes(label = name)) +
  expand_limits(x = c(-2, 2.5), y = c(-1.5, 2))
}
\seealso{
Other methods for eigen-decomposition-based techniques: 
\code{\link{methods-cmds}},
\code{\link{methods-eigen}}

Other models from the stats package: 
\code{\link{methods-cancor}},
\code{\link{methods-cmds}},
\code{\link{methods-kmeans}},
\code{\link{methods-lm}},
\code{\link{methods-prcomp}},
\code{\link{methods-princomp}}
}
\concept{methods for eigen-decomposition-based techniques}
\concept{models from the stats package}
