% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_search.R
\name{orderly_search_options}
\alias{orderly_search_options}
\title{Packet search options}
\usage{
orderly_search_options(
  location = NULL,
  allow_remote = NULL,
  pull_metadata = FALSE
)
}
\arguments{
\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{pull_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}
}
\value{
An object of class \code{orderly_search_options} which should
not be modified after creation (but see note about \code{fetch_metadata})
}
\description{
Options for controlling how packet searches are carried out, for
example via \code{\link[=orderly_search]{orderly_search()}} and \code{\link[=orderly_run]{orderly_run()}}. The details
here are never included in the metadata alongside the query (that
is, they're not part of the query even though they affect it).
(\strong{This function is deprecated, please see below.})
}
\details{
\strong{DEPRECATED}: \code{\link[=orderly_search]{orderly_search()}} and
\code{\link[=orderly_run]{orderly_run()}} now accept these arguments directly, which
is much easier to reason about and use.  A deprecation warning
will be thrown by those functions if you pass \code{options} in.
}
\examples{
orderly_search_options()
}
