% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outpack_metadata.R
\name{orderly_metadata_read}
\alias{orderly_metadata_read}
\title{Read outpack metadata json file}
\usage{
orderly_metadata_read(path, plugins = TRUE)
}
\arguments{
\item{path}{Path to the json file}

\item{plugins}{Try and deserialise data from all loaded plugins
(see Details).}
}
\value{
A list of outpack metadata; see the schema for details. In
contrast to reading the json file directly with
\code{jsonlite::fromJSON}, this function will take care to convert
scalar and length-one vectors into the expected types.
}
\description{
Low-level function for reading metadata and deserialising it. This
function can be used to directly read a metadata json file without
reference to a root which contains it. It may be useful in the
context of reading a metadata file written out as part of a failed
run.
}
\details{
Custom metadata saved by plugins may not be deserialised as
expected when called with this function, as it is designed to
operate separately from a valid orderly root (i.e., it will load
data from any file regardless of where it came from). If \code{plugins}
is \code{TRUE} (the default) then we will deserialise all data that
matches any loaded plugin.  This means that the behaviour of this
function depends on if you have loaded the plugin packages. You
can force this by running \code{orderly_config()} within any
orderly directory, which will load any declared plugins.
}
\examples{
path <- orderly_example()
id <- orderly_run("data", root = path)
meta <- orderly_metadata_read(file.path(path, ".outpack", "metadata", id))
identical(meta, orderly_metadata(id, root = path))
}
