% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{orderly_remote}
\alias{orderly_remote}
\title{Get a remote}
\usage{
orderly_remote(remote = NULL, root = NULL, locate = TRUE)
}
\arguments{
\item{remote}{Description of the location.  Typically this is a
character string indicating a remote specified in the
\code{remotes} block of your \code{orderly_config.yml}.  It is
also possible to pass in a directly created remote object (e.g.,
using \code{\link{orderly_remote_path}}, or one provided by
another package).  If left \code{NULL}, then the default remote
for this orderly repository is used - by default that is the
first listed remote.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}
}
\value{
The orderly remote, as described in
  \code{orderly_config.yml} - if no remotes are configured, or if
  the requested remote does not exist, an error will be thrown.
}
\description{
Get a remote, based on the configuration in
\code{orderly_config.yml} - different remote drivers have
different methods, and this function gives you access to these
lower-level objects.
}
\examples{
## We need two orderly repositories here - one as a "local" and one as
## a "remote" (see ?orderly_pull_archive)
path_remote <- orderly::orderly_example("demo")
path_local <- orderly::orderly_example("demo")

## Configure our remote:
path_config <- file.path(path_local, "orderly_config.yml")
txt <- readLines(path_config)
writeLines(c(
  txt,
  "remote:",
  "  default:",
  "    driver: orderly::orderly_remote_path",
  "    args:",
  paste("      path:", path_remote)),
  path_config)

## Get our remote:
remote <- orderly::orderly_remote(root = path_local)

## Can use the remote's methods to interact directly - actual methods
## depend on the remote driver being used.
remote$list_reports()
}
\seealso{
\code{\link{orderly_pull_dependencies}} which provides a
  higher-level interface to pulling from a remote (including
  adding the downloaded archive into your orderly repository), and
  see the documentation underlying the orderly remote driver that
  your \code{orderly_config.yml} declares for information about
  using that remote.
}
