% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_dogleg.R
\name{double_dogleg}
\alias{double_dogleg}
\title{Double Dogleg Trust-Region Optimization}
\usage{
double_dogleg(
  start,
  objective,
  gradient = NULL,
  hessian = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags starting with 'use_'.
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements the Double Dogleg Trust-Region algorithm for non-linear optimization.
}
\details{
This function implements the Double Dogleg method within a Trust-Region framework, 
primarily based on the work of Dennis and Mei (1979). 

\bold{Trust-Region vs. Line Search:}
While Line Search methods (like BFGS) first determine a search direction and then 
find an appropriate step length, Trust-Region methods define a neighborhood 
around the current point (the trust region with radius \eqn{\Delta}) where a local 
quadratic model is assumed to be reliable. The algorithm then finds a step that 
minimizes this model within the radius. This approach is generally more robust, 
especially when the Hessian is not positive definite.

\bold{Powell's Dogleg vs. Double Dogleg:}
Powell's original Dogleg method (1970) constructs a trajectory consisting of 
two line segments: one from the current point to the Cauchy point, and another 
from the Cauchy point to the Newton point. The "Double Dogleg" modification 
by Dennis and Mei (1979) introduces an intermediate "bias" point (\eqn{p_W}) 
along the Newton direction.
\itemize{
  \item \bold{Cauchy Point (\eqn{p_C}):} The minimizer of the quadratic model along 
        the steepest descent direction.
  \item \bold{Newton Point (\eqn{p_N}):} The minimizer of the quadratic model \eqn{(B^{-1}g)}.
  \item \bold{Double Dogleg Point (\eqn{p_W}):} A point defined as \eqn{\gamma \cdot p_N}, 
        where \eqn{\gamma} is a scaling factor (bias) that ensures the path stays 
        closer to the Newton direction while maintaining monotonic descent in 
        the model.
}
This modification allows the algorithm to perform more like a Newton method 
earlier in the optimization process compared to the standard Dogleg.
}
\references{
\itemize{
  \item Dennis, J. E., & Mei, H. H. (1979). Two New Unconstrained Optimization 
        Algorithms which use Function and Gradient Values. 
        \emph{Journal of Optimization Theory and Applications}, 28(4), 453-482.
  \item Powell, M. J. D. (1970). A Hybrid Method for Nonlinear Equations. 
        \emph{Numerical Methods for Nonlinear Algebraic Equations}.
  \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
}
}
