% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch_matrix.R
\name{branch_matrix}
\alias{branch_matrix}
\alias{branch_matrix.default}
\alias{branch_matrix.phylo}
\title{Branch matrix}
\usage{
branch_matrix(x, ...)

\method{branch_matrix}{default}(x, ...)

\method{branch_matrix}{phylo}(x, assert_validity = TRUE, ...)
}
\arguments{
\item{x}{\code{\link[ape:read.tree]{ape::phylo()}} tree object.}

\item{...}{not used.}

\item{assert_validity}{\code{logical} value (i.e. \code{TRUE} or \code{FALSE}
indicating if the argument to \code{x} should be checked for validity.
Defaults to \code{TRUE}.}
}
\value{
\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix} sparse matrix object. Each row
corresponds to a different species. Each column corresponds to a different
branch. Species that inherit from a given branch are indicated with a one.
}
\description{
Phylogenetic trees depict the evolutionary relationships between different
species. Each branch in a phylogenetic tree represents a period of
evolutionary history. Species that are connected to the same branch
share the same period of evolutionary history represented by the branch.
This function creates
a matrix that shows which species are connected with which branches. In
other words, it creates a matrix that shows which periods of evolutionary
history each species has experienced.
}
\examples{
# load Matrix package to plot matrices
library(Matrix)

# load data
data(sim_tree)

# generate species by branch matrix
m <- branch_matrix(sim_tree)

# plot data
par(mfrow = c(1,2))
plot(sim_tree, main = "phylogeny")
image(m, main = "branch matrix")

}
