% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_data_table}
\alias{wb_add_data_table}
\title{Add a data table to a worksheet}
\usage{
wb_add_data_table(
  wb,
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  col_names = TRUE,
  row_names = FALSE,
  table_style = "TableStyleLight9",
  table_name = NULL,
  with_filter = TRUE,
  sep = ", ",
  first_column = FALSE,
  last_column = FALSE,
  banded_rows = TRUE,
  banded_cols = FALSE,
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  total_row = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{A data frame}

\item{dims}{Spreadsheet cell range that will determine \code{start_col} and \code{start_row}: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write \code{x} to.}

\item{start_row}{A vector specifying the starting row to write \code{x} to.}

\item{col_names}{If \code{TRUE}, column names of \code{x} are written.}

\item{row_names}{If \code{TRUE}, the row names of \code{x} are written.}

\item{table_style}{Any table style name or "none" (see \code{vignette("openxlsx2_style_manual")})}

\item{table_name}{Name of table in workbook. The table name must be unique.}

\item{with_filter}{If \code{TRUE}, columns with have filters in the first row.}

\item{sep}{Only applies to list columns. The separator used to collapse list
columns to a character vector e.g.
\code{sapply(x$list_column, paste, collapse = sep)}.}

\item{first_column}{logical. If \code{TRUE}, the first column is bold.}

\item{last_column}{logical. If \code{TRUE}, the last column is bold.}

\item{banded_rows}{logical. If \code{TRUE}, rows are color banded.}

\item{banded_cols}{logical. If \code{TRUE}, the columns are color banded.}

\item{apply_cell_style}{Should we write cell styles to the workbook}

\item{remove_cell_style}{keep the cell style?}

\item{na.strings}{Value used for replacing \code{NA} values from \code{x}. Default
looks if \code{options(openxlsx2.na.strings)} is set. Otherwise \code{\link[=na_strings]{na_strings()}}
uses the special \verb{#N/A} value within the workbook.}

\item{inline_strings}{write characters as inline strings}

\item{total_row}{logical. With the default \code{FALSE} no total row is added.}

\item{...}{additional arguments}
}
\description{
Add data to a worksheet and format as an spreadsheet table.
}
\details{
Formulae written using \code{\link[=wb_add_formula]{wb_add_formula()}} to a Workbook object will
not get picked up by \code{read_xlsx()}. This is because only the formula is written
into the worksheet and it will be evaluated once the file is opened in
spreadsheet software.
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}.
If the data frame contains this string, the output will be broken. Similar
factor labels \code{"_openxlsx_Inf"}, \code{"_openxlsx_nInf"}, and \code{"_openxlsx_NaN"}
are reserved.

Supported classes are data frames, matrices and vectors of various types and
everything that can be converted into a data frame with \code{as.data.frame()}.
Everything else that the user wants to write should either be converted into
a vector or data frame or written in vector or data frame segments. This
includes base classes such as \code{table}, which were coerced internally in the
predecessor of this package.

Even vectors and data frames can consist of different classes. Many base
classes are covered, though not all and far from all third-party classes.
When data of an unknown class is written, it is handled with \code{as.character()}.
It is not possible to write character nodes beginning with \verb{<r>} or \verb{<r/>}. Both
are reserved for internal functions. If you need these. You have to wrap
the input string in \code{fmt_txt()}.

The columns of \code{x} with class Date/POSIXt, currency, accounting, hyperlink,
percentage are automatically styled as dates, currency, accounting,
hyperlinks, percentages respectively. When writing POSIXt, the users local
timezone should not matter. The openxml standard does not have a timezone
and the conversion from the local timezone should happen internally, so that
date and time are converted, but the timezone is dropped. This conversion
could cause a minor precision loss. The datetime in R and in spreadsheets
might differ by 1 second, caused by floating point precision. When read from
the worksheet, starting with \code{openxlsx2} release \code{1.15} the datetime is
returned in \code{"UTC"}.

Functions \code{\link[=wb_add_data]{wb_add_data()}} and \code{\link[=wb_add_data_table]{wb_add_data_table()}} behave quite similar. The
distinction is that the latter creates a table in the worksheet that can be
used for different kind of formulas and can be sorted independently, though
is less flexible than basic cell regions.
}
\section{Modify total row argument}{
It is possible to further tweak the total row. In addition to the default
\code{FALSE} possible values are \code{TRUE} (the xlsx file will create column sums
each variable).

In addition it is possible to tweak this further using a character string
with one of the following functions for each variable: \code{"average"},
\code{"count"}, \code{"countNums"}, \code{"max"}, \code{"min"}, \code{"stdDev"}, \code{"sum"}, \code{"var"}.
It is possible to leave the cell empty \code{"none"} or to create a text input
using a named character with name \code{text} like: \code{c(text = "Total")}.
It's also possible to pass other spreadsheet software functions if they
return a single value and hence \code{"SUM"} would work too.
}

\examples{
wb <- wb_workbook()$add_worksheet()$
  add_data_table(
    x = as.data.frame(USPersonalExpenditure),
    row_names = TRUE,
    total_row = c(text = "Total", "none", "sum", "sum", "sum", "SUM"),
    stringsAsFactors = FALSE
  )
}
\seealso{
Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}

Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
