% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_data}
\alias{wb_add_data}
\title{Add data to a worksheet}
\usage{
wb_add_data(
  wb,
  sheet = current_sheet(),
  x,
  dims = wb_dims(start_row, start_col),
  start_col = 1,
  start_row = 1,
  array = FALSE,
  col_names = TRUE,
  row_names = FALSE,
  with_filter = FALSE,
  name = NULL,
  sep = ", ",
  apply_cell_style = TRUE,
  remove_cell_style = FALSE,
  na.strings = na_strings(),
  inline_strings = TRUE,
  enforce = FALSE,
  ...
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{dims}{Spreadsheet cell range that will determine \code{start_col} and \code{start_row}: "A1", "A1:B2", "A:B"}

\item{start_col}{A vector specifying the starting column to write \code{x} to.}

\item{start_row}{A vector specifying the starting row to write \code{x} to.}

\item{array}{A bool if the function written is of type array}

\item{col_names}{If \code{TRUE}, column names of \code{x} are written.}

\item{row_names}{If \code{TRUE}, the row names of \code{x} are written.}

\item{with_filter}{If \code{TRUE}, add filters to the column name row.
NOTE: can only have one filter per worksheet.}

\item{name}{The name of a named region if specified.}

\item{sep}{Only applies to list columns. The separator used to collapse list
columns to a character vector e.g. \code{sapply(x$list_column, paste, collapse = sep)}.}

\item{apply_cell_style}{Should we write cell styles to the workbook}

\item{remove_cell_style}{keep the cell style?}

\item{na.strings}{Value used for replacing \code{NA} values from \code{x}. Default
looks if \code{options(openxlsx2.na.strings)} is set. Otherwise \code{\link[=na_strings]{na_strings()}}
uses the special \verb{#N/A} value within the workbook.}

\item{inline_strings}{write characters as inline strings}

\item{enforce}{enforce that selected dims is filled. For this to work, \code{dims} must match \code{x}}

\item{...}{additional arguments}
}
\value{
A \code{wbWorkbook}, invisibly.
}
\description{
Add data to worksheet with optional styling.
}
\details{
Formulae written using \code{\link[=wb_add_formula]{wb_add_formula()}} to a Workbook object will
not get picked up by \code{read_xlsx()}. This is because only the formula is written
and left to Excel to evaluate the formula when the file is opened in Excel.
The string \code{"_openxlsx_NA"} is reserved for \code{openxlsx2}.
If the data frame contains this string, the output will be broken. Similar
factor labels \code{"_openxlsx_Inf"}, \code{"_openxlsx_nInf"}, and \code{"_openxlsx_NaN"}
are reserved.

Supported classes are data frames, matrices and vectors of various types and
everything that can be converted into a data frame with \code{as.data.frame()}.
Everything else that the user wants to write should either be converted into
a vector or data frame or written in vector or data frame segments. This
includes base classes such as \code{table}, which were coerced internally in the
predecessor of this package.

Even vectors and data frames can consist of different classes. Many base
classes are covered, though not all and far from all third-party classes.
When data of an unknown class is written, it is handled with \code{as.character()}.
It is not possible to write character nodes beginning with \verb{<r>} or \verb{<r/>}. Both
are reserved for internal functions. If you need these. You have to wrap
the input string in \code{fmt_txt()}.

The columns of \code{x} with class Date/POSIXt, currency, accounting, hyperlink,
percentage are automatically styled as dates, currency, accounting,
hyperlinks, percentages respectively. When writing POSIXt, the users local
timezone should not matter. The openxml standard does not have a timezone
and the conversion from the local timezone should happen internally, so that
date and time are converted, but the timezone is dropped. This conversion
could cause a minor precision loss. The datetime in R and in spreadsheets
might differ by 1 second, caused by floating point precision. When read from
the worksheet, starting with \code{openxlsx2} release \code{1.15} the datetime is
returned in \code{"UTC"}.

Functions \code{\link[=wb_add_data]{wb_add_data()}} and \code{\link[=wb_add_data_table]{wb_add_data_table()}} behave quite similar. The
distinction is that the latter creates a table in the worksheet that can be
used for different kind of formulas and can be sorted independently, though
is less flexible than basic cell regions.
}
\examples{
## See formatting vignette for further examples.

## Options for default styling (These are the defaults)
options("openxlsx2.dateFormat" = "mm/dd/yyyy")
options("openxlsx2.datetimeFormat" = "yyyy-mm-dd hh:mm:ss")
options("openxlsx2.numFmt" = NULL)

#############################################################################
## Create Workbook object and add worksheets
wb <- wb_workbook()

## Add worksheets
wb$add_worksheet("Cars")
wb$add_worksheet("Formula")

x <- mtcars[1:6, ]
wb$add_data("Cars", x, start_col = 2, start_row = 3, row_names = TRUE)

#############################################################################
## Hyperlinks
## - vectors/columns with class 'hyperlink' are written as hyperlinks'

v <- rep("https://CRAN.R-project.org/", 4)
names(v) <- paste0("Hyperlink", 1:4) # Optional: names will be used as display text
class(v) <- "hyperlink"
wb$add_data("Cars", x = v, dims = "B32")

#############################################################################
## Formulas
## - vectors/columns with class 'formula' are written as formulas'

df <- data.frame(
  x = 1:3, y = 1:3,
  z = paste(paste0("A", 1:3 + 1L), paste0("B", 1:3 + 1L), sep = "+"),
  stringsAsFactors = FALSE
)

class(df$z) <- c(class(df$z), "formula")

wb$add_data(sheet = "Formula", x = df)

#############################################################################
# update cell range and add mtcars
xlsxFile <- system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2")
wb2 <- wb_load(xlsxFile)

# read dataset with inlinestr
wb_to_df(wb2)
wb2 <- wb2 \%>\% wb_add_data(sheet = 1, mtcars, dims = wb_dims(4, 4))
wb_to_df(wb2)
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_hyperlink}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
