% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argument_types.R
\name{ProcessGraphArgument}
\alias{ProcessGraphArgument}
\title{ProcessGraphArgument}
\value{
Object of \code{\link[=R6Class]{R6Class()}} representing a ProcessGraph.
}
\description{
Inheriting from \code{\link[=Argument]{Argument()}} in order to represent an argument that contains a process or a derivable value (formerly known
as callback). The ProcessGraphArgument operates on the reduced data of a data cube. For example reducing or aggregating over
the temporal dimension results in a time series that has to be reduced into a single value or aggregated into another time
series. The value of a ProcessGraphArgument is usually a function that will be coerced into \code{\link[=Process]{Process()}}. The function
is required to use the same amount of parameters as \code{ProcessGraphParameter} objects are defined, because during the coercion
those \code{ProcessGraphParameter} are passed to function. Additional information can be found in the openEO API documentation:
\itemize{
\item \url{https://api.openeo.org/#section/Processes/Process-Graphs}
}
}
\section{Methods}{

\describe{
\item{\verb{$getProcessGraphParameters()}}{returns the available list \code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}}}
\item{\verb{$setProcessGraphParameters(parameters)}}{assigns a list of \code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}} to the ProcessGraph}
}
}

\section{Arguments}{

\describe{
\item{\code{parameters}}{the \code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}} list}
}
}

\seealso{
\code{\link[=Array]{Array()}}, \code{\link[=Integer]{Integer()}}, \code{\link[=EPSGCode]{EPSGCode()}}, \code{\link[=String]{String()}}, \code{\link[=Number]{Number()}},
\code{\link[=Date]{Date()}}, \code{\link[=RasterCube]{RasterCube()}}, \code{\link[=VectorCube]{VectorCube()}}, \code{\link[=ProcessGraphArgument]{ProcessGraphArgument()}},
\code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}}, \code{\link[=OutputFormatOptions]{OutputFormatOptions()}}, \code{\link[=GeoJson]{GeoJson()}},
\code{\link[=Boolean]{Boolean()}}, \code{\link[=DateTime]{DateTime()}}, \code{\link[=Time]{Time()}}, \code{\link[=BoundingBox]{BoundingBox()}}, \code{\link[=Kernel]{Kernel()}},
\code{\link[=TemporalInterval]{TemporalInterval()}}, \code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=CollectionId]{CollectionId()}}, \code{\link[=OutputFormat]{OutputFormat()}},
\code{\link[=AnyOf]{AnyOf()}}, \code{\link[=ProjDefinition]{ProjDefinition()}}, \code{\link[=UdfCodeArgument]{UdfCodeArgument()}}, \code{\link[=UdfRuntimeArgument]{UdfRuntimeArgument()}} and
\code{\link[=UdfRuntimeVersionArgument]{UdfRuntimeVersionArgument()}},\code{\link[=TemporalIntervals]{TemporalIntervals()}}, \code{\link[=MetadataFilter]{MetadataFilter()}}
}
