% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openai.R
\name{openai}
\alias{openai}
\title{An R6 Class Interface to OpenAI API}
\description{
Provides methods to interact with OpenAI API including
  fetching model details, generating completions, managing files, and more.
  Always ensure that the API key is kept private.
}
\examples{
\donttest{
Sys.setenv(OPENAI_KEY="you openai key")
aaa <- openai$new(Sys.getenv("OPENAI_KEY"))
#if need proxy
#aaa$set_proxy("127.0.0.1", 10890)
# List model
aaa$models$list()
}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{models}}{class}

\item{\code{files}}{class}

\item{\code{fine_tuning}}{class}

\item{\code{chat}}{class}

\item{\code{audio}}{class}

\item{\code{embeddings}}{class}

\item{\code{images}}{class}

\item{\code{moderations}}{class}

\item{\code{assistants}}{class}

\item{\code{threads}}{class}

\item{\code{messages}}{class}

\item{\code{runs}}{class}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-openai-new}{\code{openai$new()}}
\item \href{#method-openai-set_proxy}{\code{openai$set_proxy()}}
\item \href{#method-openai-clone}{\code{openai$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-new"></a>}}
\if{latex}{\out{\hypertarget{method-openai-new}{}}}
\subsection{Method \code{new()}}{
Initialize the OpenAI API interface with the provided API key.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$new(api_key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{api_key}}{The OpenAI API key.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-set_proxy"></a>}}
\if{latex}{\out{\hypertarget{method-openai-set_proxy}{}}}
\subsection{Method \code{set_proxy()}}{
Configure the proxy settings.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$set_proxy(proxy_ip, proxy_port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{proxy_ip}}{character Required. The IP address of the proxy.}

\item{\code{proxy_port}}{character Required. The port number of the proxy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-openai-clone"></a>}}
\if{latex}{\out{\hypertarget{method-openai-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{openai$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
