% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{n_most_frequent_terms}
\alias{n_most_frequent_terms}
\title{Select \code{n} most prevalent terms in \code{term_sets}}
\usage{
n_most_frequent_terms(ontology, term_sets, n,
  terms = unique(unlist(term_sets)))
}
\arguments{
\item{ontology}{\code{ontology_index} object}

\item{term_sets}{List of character vectors of ontological term IDs}

\item{n}{Integer}

\item{terms}{Character vector of ontological terms}
}
\value{
Character vector of length at most \code{n}
}
\description{
Selects \code{n} most prevalent terms in set of term sets/annotations including implicit terms. If more than one term are tied at the \code{n}th position, all terms are included in the result.
}
\examples{
library(ontologyIndex)
data(hpo)
n_most_frequent_terms(hpo, c("HP:0001873"), 
list(term_sets=list("HP:0001873", "HP:0001902")), n=2)
}
\seealso{
\code{\link{remove_terms_with_less_than_n_occurrences}}
}

