% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_pfs.R
\name{compute_pfs}
\alias{compute_pfs}
\title{Compute progression-free-survival rate given sample}
\usage{
compute_pfs(
  model,
  t,
  parameter_sample = NULL,
  warmup = 500L,
  nsim = 1000L,
  seed = NULL,
  ...
)
}
\arguments{
\item{model}{an object of class \link{srpmodel} containing prior information}

\item{t}{a vector of time-points at which the PFS rate should be computed}

\item{parameter_sample}{a stanfit object with samples from the respective model.}

\item{warmup}{integer, number of warm-up samples for the MCMC sampler
before retaining samples; see \code{warmup} parameter in \code{\link[rstan:stan]{rstan::stan()}}.}

\item{nsim}{integer, number of samples to draw}

\item{seed}{integer, fixed random seed; NULL for no fixed seed}

\item{...}{further arguments passed to method implementations}
}
\value{
a data frame with samples of PFS rates at each of the time points
in the vector t.
}
\description{
\code{compute_pfs()} computes the progression-free-survival rate at specified
times given a paramter sample.
}
\examples{
mdl <- create_srpmodel(A = define_srp_prior())
smpl <- sample_prior(mdl, nsim = 500, seed = 34L)
dplyr::filter(
  compute_pfs(mdl, t = seq(0, 12), parameter_sample = smpl),
  iter == 1
)

}
