% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_museum_locations.R
\name{nyc_museum_locations}
\alias{nyc_museum_locations}
\title{MUSEUM}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Recreation/MUSEUM/fn6f-htvy/about_data>
}
\usage{
nyc_museum_locations(limit = 10000, filters = list(), timeout_sec = 30)
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}

\item{timeout_sec}{Request timeout in seconds (default = 30).}
}
\value{
A tibble containing Locations of New York City Museums data.
}
\description{
Downloads Locations of New York City Museums from NYC Open Data.
}
\details{
Locations of New York City Museums
}
\examples{
# Examples that hit the live NYC Open Data API are wrapped so CRAN checks
# do not fail when the network is unavailable or slow.
\donttest{
if (curl::has_internet()) {
  # Quick example (fetch 10 rows)
  small_sample <- nyc_museum_locations(limit = 10)
  head(small_sample)

  nyc_museum_locations(limit = 5000)
  nyc_museum_locations(filters = list(city = "New York"))
}
}
}
