% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nyc_311.R
\name{nyc_311}
\alias{nyc_311}
\title{NYC 311 Service Requests}
\source{
NYC Open Data: <https://data.cityofnewyork.us/Social-Services/311-Service-Requests-from-2010-to-Present/erm2-nwe9/about_data>
}
\usage{
nyc_311(limit = 10000, filters = list())
}
\arguments{
\item{limit}{Number of rows to retrieve (default = 10,000).}

\item{filters}{Optional list of field-value pairs to filter results.}
}
\value{
A tibble containing 311 Service Request data.
}
\description{
Downloads NYC 311 Service Request data from NYC Open Data.
}
\details{
This dataset contains all service requests made to NYC 311 since 2010.
Data is updated daily and includes agency, complaint type, location, and resolution.
}
\examples{

# Quick example (fetch 10 rows)
small_sample <- nyc_311(limit = 10)
head(small_sample)

\donttest{
nyc_311(limit = 5000)
nyc_311(filters = list(agency = "NYPD", city = "BROOKLYN"))
}
}
