% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_almost_constant.R
\name{is_almost_constant}
\alias{is_almost_constant}
\title{Test whether a vector is almost constant}
\usage{
is_almost_constant(x, threshold = 1, na_rm = FALSE)
}
\arguments{
\item{x}{A vector to be tested.}

\item{threshold}{A numeric scalar in the interval \eqn{[0,1]} specifying the
minimum required proportion of the most frequent value. Defaults to 1.}

\item{na_rm}{Logical; if \code{TRUE}, \code{NA} values are removed before computing
proportions. If \code{FALSE}, \code{NA} is treated as an ordinary value, so a large
number of \code{NA}s can cause the function to return \code{TRUE}.}
}
\value{
A logical scalar. Returns \code{TRUE} in the following cases:
\itemize{
\item \code{x} is empty or has length one.
\item \code{x} contains only \code{NA} values.
\item The proportion of the most frequent value in \code{x} is greater than or
equal to \code{threshold}.
Otherwise, returns \code{FALSE}.
}
}
\description{
Check if a vector contains (almost) the same value in the majority of its
elements. The function returns \code{TRUE} if the proportion of the most frequent
value in \code{x} is greater than or equal to the specified \code{threshold}.

This is useful for detecting low-variability or degenerate variables, which
may be uninformative in modeling or analysis.
}
\examples{
is_almost_constant(1)
is_almost_constant(1:10)
is_almost_constant(c(NA, NA, NA), na_rm = TRUE)
is_almost_constant(c(NA, NA, NA), na_rm = FALSE)
is_almost_constant(c(NA, NA, NA, 1, 2), threshold = 0.5, na_rm = FALSE)
is_almost_constant(c(NA, NA, NA, 1, 2), threshold = 0.5, na_rm = TRUE)

}
\seealso{
\code{\link[=remove_almost_constant]{remove_almost_constant()}}, \code{\link[=unique]{unique()}}, \code{\link[=table]{table()}}
}
\author{
Michal Burda
}
