% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caller.R
\name{do}
\alias{do}
\alias{do_}
\title{Making function calls, with full control of argument scope.}
\usage{
do(...)

do_(...)
}
\arguments{
\item{...}{A function to call and list(s) of arguments to pass. All
should be \code{quotation} or \code{dots} objects, except the first
argument for \code{do} which is quoted literally.}
}
\value{
The return value of the call.
}
\description{
The functions \code{do} and \code{do_} construct and invoke a function call.
In combination with \link{dots} and \link{quotation} objects they allow you
to control the scope of the function call and each of its arguments
independently.
}
\details{
For \code{do_} all arguments should be \code{quotation} or \code{dots} objects, or
convertible to such using \code{as.quo()}. They will be concatenated
together by \link{c.dots} to form the call list (a \code{dots} object).
For \code{do} the first argument is quoted literally, but the
rest of the arguments are evaluated the same way as \code{do_}.

The head, or first element of the call list, represents the
function, and it should evaluate to a function object. The rest of
the call list is used as that function's arguments.

When a quotation is used as the first element, the call is evaluated
from the environment given in that quotation. This means that calls
to \code{\link[=caller]{caller()}} (or \code{parent.frame()}) from within that function
should return that environment.

\code{do} is intended to be a replacement for base function \link{do.call}.
For instance these two lines are similar in effect:

\if{html}{\out{<div class="sourceCode">}}\preformatted{do.call("complex", list(imaginary = 1:3))
do(complex, dots(imaginary = 1:3))
}\if{html}{\out{</div>}}

As are all these:

\if{html}{\out{<div class="sourceCode">}}\preformatted{do.call("f", list(as.name("A")), envir = env)
do_(quo(f, env), quo(A, env)):
do_(dots_(list(as.name("f"), as.name("A")), env))
do_(dots_(alist(f, A), env))
}\if{html}{\out{</div>}}
}
\note{
When the environment of the call head differs from that of
the arguments, \code{do} may make a temporary binding of \code{...} to pass
arguments. This will cause some primitive functions, like (
\code{\link{<-}}, or \code{\link{for}}), to fail with an error like
"'...' used an in incorrect context," because these primitives do
not understand how to unpack \code{...}. To avoid the use of \code{...},
ensure that all args have the same environment as the call head,
or are forced.

For the specific case of calling \verb{<-}, you can use \code{\link{set_}} to
make assignments.
}
\seealso{
get_call do.call match.call set_
}
