% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeAutoGenIds.R
\name{removeAutoGenIds}
\alias{removeAutoGenIds}
\title{Remove automatically generated IDs from pedigree}
\usage{
removeAutoGenIds(ped)
}
\arguments{
\item{ped}{datatable that is the \code{Pedigree}. It contains pedigree
information. The \code{id}, \code{sire}, and \code{dame} columns are
required.}
}
\value{
A pedigree with automatically generated IDs removed.
}
\description{
Currently uses leading "U" to identify automatically generated IDs.
TODO change identification of automatically generated IDs from looking for
an initial "U" at the beginning of an ID to a function call so that actual
ID that start with a "U" are possible.
}
\examples{
examplePedigree <- nprcgenekeepr::examplePedigree
length(examplePedigree$id)
ped <- removeAutoGenIds(examplePedigree)
length(ped$id)

}
