% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonet_plot.R
\name{nonet_plot}
\alias{nonet_plot}
\title{Plot the predictions or results of nonet_ensemble}
\usage{
nonet_plot(x, y, dataframe, plot_type = NULL, nonet_size = 20,
  nonet_alpha = 0.3, nonet_bins = 25)
}
\arguments{
\item{x}{x axis variable name or histogram entity name}

\item{y}{y axis variable name}

\item{dataframe}{dataframe which is used for plotting purpose.}

\item{plot_type}{type of plot, if not provided it takes "NULL"}

\item{nonet_size}{size of plot need to feed in ggplot}

\item{nonet_alpha}{value of alpha for ggplot}

\item{nonet_bins}{number of bins for histogram}
}
\value{
plotted for the plot results provided as input.
}
\description{
Plot the predictions or results of nonet_ensemble
}
\examples{
# nonet_plot functionality can be explained via below example
# Setup
library(caret)
library(nonet)
library(ggplot2)

# Load Data
dataframe <- data.frame(banknote_authentication[600:900, ])
dataframe$class <- as.factor(ifelse(dataframe$class >= 1, 'Yes', 'No'))

# Spliting into train and test
index <- createDataPartition(dataframe$class, p=0.75, list=FALSE)
trainSet <- dataframe[ index,]
testSet <- dataframe[-index,]

# Feature selection 
 control <- rfeControl(functions = rfFuncs,
  method = "repeatedcv",
  repeats = 2,
  verbose = FALSE)

outcomeName <- 'class'
predictors <- c("curtosis", "entropy")

# Model Training & predictions
banknote_rf <- train(trainSet[,predictors],trainSet[,outcomeName],method='rf')
predictions_rf_raw <- predict.train(object=banknote_rf,testSet[,predictors],type="raw")

# Results
nonet_eval_rf <- confusionMatrix(predictions_rf_raw,testSet[,outcomeName])
eval_rf_df <- data.frame(nonet_eval_rf$table)
nonet_plot(eval_rf_df$Prediction, eval_rf_df$Reference, eval_rf_df, plot_type = "point")
}
