% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{main_noisySBM_GGM}
\alias{main_noisySBM_GGM}
\title{GGM Inference from Noisy Data by Multiple Testing using SILGGM and Drton test statistics}
\usage{
main_noisySBM_GGM(
  X,
  Meth = "Ren",
  NIG = NULL,
  threshold = 0.5,
  Nbrepet = 2,
  rho = NULL,
  tau = NULL,
  a = NULL,
  b = NULL,
  c = NULL,
  d = NULL,
  n0 = 1,
  eta0 = 1,
  zeta0 = 1,
  alpha = 0.1,
  Qup = NULL,
  nbCores = parallel::detectCores(),
  nbOfZ = 12,
  sigma0 = 1,
  sigma1 = 1,
  percentageOfPerturbation = 0.3,
  verbatim = TRUE
)
}
\arguments{
\item{X}{A n by p matrix containing a n-sample of a p-vector}

\item{Meth}{Choice of test statistics between "Ren", "Jankova_NW", "Jankova_GL", "Liu_SL", "Liu_L", and "zTransform" (warning "zTransform" only work if n>p)}

\item{NIG}{A Boolean (automatically chosen according to the selected method : NIG=FALSE except for "Liu_SL" and "Liu_L" test statistics as input). If FALSE, the variance under the alternative hypothesis in assumed to be known. If TRUE, the variances under the alternatives are unknown and estimated with the NIG method.}

\item{threshold}{Threshold use when updating the latent graphs structure from l-values (by default threshold=0.5)}

\item{Nbrepet}{Number of times the algorithm is repeated (by default Nbrepet=2)}

\item{rho}{Hyperparameter of the non-NIG method (by default rho=1)}

\item{tau}{Hyperparameter of the non-NIG method (by default tau=1)}

\item{a}{Hyperparameter of the NIG method (by default a=0)}

\item{b}{Hyperparameter of the NIG method (by default b=1)}

\item{c}{Hyperparameter of the NIG method (by default c=1)}

\item{d}{Hyperparameter of the NIG method (by default d=1)}

\item{n0}{Hyperparameter (by default n0=1)}

\item{eta0}{Hyperparameter (by default eta0=1)}

\item{zeta0}{Hyperparameter (by default zeta0=1)}

\item{alpha}{Level of significance of the multiple testing procedure (by default alpha=0.1)}

\item{Qup}{Maximal number of cluster (by default Qup =10)}

\item{nbCores}{Nb of cores to be used during calculations (by default nbCores=parallel::detectCores())}

\item{nbOfZ}{Nb of initialization (by default nbOfZ=12)}

\item{sigma0}{standard deviation under the null hypothesis (by default sigma0=1)}

\item{sigma1}{standard deviation under the alternative hypothesis in the non-NIG method (by default sigma1=1)}

\item{percentageOfPerturbation}{perturbation during initialization  (by default percentageOfPerturbation=0.3)}

\item{verbatim}{print information messages}
}
\value{
\item{\code{A}}{the adjacency matrix of the inferred graph}
\item{\code{Z}}{the inferred clustering}
\item{\code{theta}}{the parameters of the noisySBM at the end}
\item{\code{Q}}{the number of clusters at the end}
#' @examples
main_noisySBM_GGM(GGMtest$dataMatrix,Meth="Ren",NIG=TRUE,Qup=10,nbOfZ=1)
}
\description{
The \code{main_noisySBM_GGM()} function is a key feature of the \code{noisysbmGGM} package,
dedicated to Gaussian Graphical Model (GGM) inference. This function takes an $n$-sample of a Gaussian vector
of dimension $p$ and provides the GGM associated with the partial correlation structure of the vector.
GGM inference is essential in capturing the underlying relationships between the vector's coefficients,
helping users uncover meaningful interactions while controlling the number of false discoveries.
}
\seealso{
main_noisySBM
}
