\name{nl.corrts}
\alias{nl.corrts}
\title{
  Autocorrelated two stage estimate
}
\description{
  Two stage estimate for nonlinear regreession model with autocorrelated error.
}
\usage{
nl.corrts(formula, data, start = getInitial(formula, data), 
control = nlr.control(tolerance = 0.001, minlanda = 1/2^10, 
maxiter = 25 * length(start)), correlation = NULL, ...)
}
\arguments{
  \item{formula}{
    nl.form object of the nonlinear function model. See \code{\link{nl.form}} object.
  }
  \item{data}{
    list of data with the response and predictor as name of variable.
  }
  \item{start}{
    list of starting value parameter, name of parameters must be represented as names of variable in the list.
  }
  \item{control}{
    nlr.control object, include tolerance, maxiter,... see \code{\link{nlr.control}}.
  }
  \item{correlation}{
      correlation structure, at the moment parameter of AR(p) process.
}
  \item{\dots}{
    any argument pass to \code{formula}
}
}
\details{
  In first stage nonlinear regression parameter estimate and in second stage autocorrelation structure estimate and finally the generalized least square estimates the function model parameters.
}
\value{
  \item{fited}{\code{\link{nl.fitt.gn}} object generated by \code{\link{nlsqr.gn}} function.}
  \item{tm}{ fitted time series model for residuals.}
}
\references{
Riazoshams, H., Midi, H., Sharipov, O. S.H, (2010). The Performance of Robust Two Stage Estimator in Nonlinear Regression with autocorrelated Error, Communications in Statistics - Simulation and Computation, 39: 1251-1268.
}
\author{
  Hossein Riazoshams, Jul 2009.
  Email: \email{riazihosein@gmail.com}
  URL \url{http://www.riazoshams.com/nlr/}
}
\note{
  This function currently run with AR process. The robust estimate is don by \code{\link{nl.robcorrts}} function.
  This function called from \code{\link{nlr}} function, since the correlation parameters have to be estimated it is more efficient to be called from \code{\link{nlr}} rather than directly by user.
}
\seealso{
\code{\link{nl.robcorrts}}, \code{\link{nlsqr.gn}}, \code{\link{nl.fitt.gn}}, \code{\link{nlr.control}}
}
\examples{
library(nlme)
xr = tadr.ir[, 1]
yr = tadr.ir[, 2]
a1 <-  nl.corrts( nlrobj5[[18]],data=list(xr = xr, yr = yr),correlation=corAR1(0.8))
a1$parameters              
}
\keyword{autocorrelated erro}
\keyword{two stage estimate}
\keyword{robust two stage estimate}
