% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProp.R
\name{addCmtProp}
\alias{addCmtProp}
\alias{addBioavailability}
\alias{addLag}
\alias{addDur}
\alias{addRate}
\alias{addIni}
\title{Add a property to a compartment}
\usage{
addCmtProp(ui, prop = c("f", "lag", "dur", "rate", "ini"), cmt)

addBioavailability(ui, cmt)

addLag(ui, cmt)

addDur(ui, cmt)

addRate(ui, cmt)

addIni(ui, cmt)
}
\arguments{
\item{ui}{rxode2 ui object}

\item{prop}{property to add to a compartment:

 - \code{F}: bioavailability

 - \code{lag}: absorption lag time

- \code{dur}: modeled duration of infusion

- \code{rate}: modeled infusion rate

- \code{ini}: initial value of the compartment}

\item{cmt}{compartment to apply the property to}
}
\value{
rxode2 ui object with property applied
}
\description{
Add a property to a compartment
}
\section{Functions}{
\itemize{
\item \code{addBioavailability()}: Adds the bioavailability to a compartment in the model

\item \code{addLag()}: Adds the lag-time to a compartment in the model

\item \code{addDur()}: Adds the modeled duration to a compartment in the model

\item \code{addRate()}: Adds the modeled rate to a compartment in the model

\item \code{addIni()}: Adds the initial value to the compartment

}}
\examples{

readModelDb("PK_3cmt_des") |> addCmtProp("f", "depot")

readModelDb("PK_3cmt_des") |> addBioavailability(depot)

readModelDb("PK_3cmt_des") |> addLag(depot)

readModelDb("PK_3cmt_des") |> addDur(depot)

readModelDb("PK_3cmt_des") |> addRate(depot)

readModelDb("PK_3cmt_des") |> addIni(depot)

}
\author{
Matthew L. Fidler
}
