% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateY.R
\name{simulateY.lme}
\alias{simulateY.lme}
\title{Simulates values for an \code{lme} object}
\usage{
\method{simulateY}{lme}(
  object,
  nsim = 1,
  seed = as.integer(runif(1, 0, .Machine$integer.max)),
  ...,
  verbose = FALSE,
  sigma
)
}
\arguments{
\item{object}{an \code{\link[nlme:lme]{lme}} object with a model fit for which the dependent variable is to be simulated.}

\item{nsim}{number of simulations. By default, \code{nsim = 1}.}

\item{seed}{integer scalar used to initiate the random number generator.}

\item{\dots}{some methods for this generic function may require additional arguments.}

\item{verbose}{logical. If \code{TRUE}, basic information about arguments is provided. By default set to \code{FALSE}.}

\item{sigma}{numeric scalar. Allows simulations employing an alternative value of the scale parameter.}
}
\value{
Numeric matrix with the number of columns determined by the \code{nsim} argument.
}
\description{
This is a method for the \code{\link{simulateY}} generic function.
}
\details{
Simulates values of the dependent variable for a fitted \code{\link[nlme:lme]{lme}} model.
Data with one level of grouping only.
}
\examples{

\dontrun{
  library(nlme)
  fm1 <- lme(distance ~ age, data = Orthodont)
  simulateY(fm1)
}

}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
