% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_players_seasons.R
\name{nhl_url_players_stats}
\alias{nhl_url_players_stats}
\title{Create an NHL API stats URL for players}
\usage{
nhl_url_players_stats(playerIds, params = NULL)
}
\arguments{
\item{playerIds}{\code{integer()}, vector of one or more ids of the
players. The ids correspond to the ids expected by the NHL
API people endpoint. For most cases the \code{playerNames} argument
can be provided for more convenient usage.}

\item{params}{\verb{named list()} of parameters that will be
concatenated to the end of the URLs after \verb{?}. Parameters
can have multiple values, in which case multiple URLs
are created. Multiple parameters are separated by \code{&}.}
}
\value{
\code{character()}, of API URLs, same length as \code{playerIds}.
}
\description{
Create an NHL API stats URL for players
}
\examples{
  nhlapi:::nhl_url_players_stats(8477474)

}
