% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/quantile.R
\docType{methods}
\name{quantile}
\alias{quantile}
\alias{quantile,CompositionMatrix-method}
\title{Sample Quantiles}
\usage{
\S4method{quantile}{CompositionMatrix}(x, ..., probs = seq(0, 1, 0.25), na.rm = FALSE, names = TRUE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{probs}{A \code{\link{numeric}} vector of probabilities with values in \eqn{[0,1]}.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values be removed?}

\item{names}{A \code{\link{logical}} scalar: should results be named?}
}
\value{
A \code{\link{numeric}} matrix.
}
\description{
Sample Quantiles
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Mean
mean(coda)

## Quantile
quantile(coda)
}
\references{
Filzmoser, P., Hron, K. & Reimann, C. (2009). Univariate Statistical
Analysis of Environmental (Compositional) Data: Problems and Possibilities.
\emph{Science of The Total Environment}, 407(23): 6100-6108.
\doi{10.1016/j.scitotenv.2009.08.008}.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{condense}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{mean}()},
\code{\link{pip}()},
\code{\link{scale}()},
\code{\link{variance}()},
\code{\link{variance_total}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
