% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{networkLite}
\alias{networkLite}
\alias{networkLite.edgelist}
\alias{networkLite.matrix}
\alias{networkLite.numeric}
\alias{networkLite_initialize}
\title{networkLite Constructor Utilities}
\usage{
networkLite(x, ...)

\method{networkLite}{edgelist}(
  x,
  attr = list(vertex.names = seq_len(net_attr[["n"]]), na = logical(net_attr[["n"]])),
  net_attr = attributes(x)[setdiff(names(attributes(x)), c("class", "dim", "dimnames",
    "vnames", "row.names", "names", "mnext"))],
  ...,
  atomize = FALSE
)

\method{networkLite}{matrix}(
  x,
  attr = list(vertex.names = seq_len(net_attr[["n"]]), na = logical(net_attr[["n"]])),
  net_attr = attributes(x)[setdiff(names(attributes(x)), c("class", "dim", "dimnames",
    "vnames", "row.names", "names", "mnext"))],
  ...,
  atomize = FALSE
)

\method{networkLite}{numeric}(x, directed = FALSE, bipartite = FALSE, ...)

networkLite_initialize(x, directed = FALSE, bipartite = FALSE, ...)
}
\arguments{
\item{x}{Either an \code{edgelist} class network representation, or a number
specifying the network size. The \code{edgelist} may be either a \code{tibble}
or a \code{matrix}. If a \code{tibble} is passed, it should have integer columns
named \code{".tail"} and \code{".head"} for the tails and heads of edges,
and may include edge attributes as additional columns. If a
\code{matrix} is passed, it should have two columns, the first being
the tails of edges and the second being the heads of edges; edge
attributes are not supported for \code{matrix} arguments. Edges
should be sorted, first on tails then on heads. See
\code{\link[network:as.edgelist]{network::as.edgelist}} for information on producing such
\code{edgelist} objects from \code{network} objects.}

\item{...}{additional arguments}

\item{attr}{A named list of vertex attributes, coerced to \code{tibble}.
Each element of \code{attr} should be an atomic vector or list of
length equal to the number of nodes in the network.}

\item{net_attr}{A named list of network attributes. Must include the network
size attribute named \code{"n"}. Defaults to a subset of the \code{attr}-style
attributes of \code{x} for backwards compatibility; it is recommended that
new code specify \code{net_attr} explicitly rather than relying on this
default.}

\item{atomize}{Logical; should we call \code{\link{atomize}} on the
\code{networkLite} before returning it? Note that unlike
\code{\link{as.networkLite}}, the default value here is \code{FALSE}.}

\item{directed, bipartite}{Common network attributes that may be set via
arguments to the \code{networkLite.numeric} method.}
}
\value{
A \code{networkLite} object constructed according to the inputs.
}
\description{
Constructor methods for \code{networkLite} objects.
}
\details{
Currently there are several distinct \code{networkLite} constructor
methods available.

The \code{edgelist} method takes an \code{edgelist} class object \code{x}, a named
list of vertex attributes \code{attr}, and a named list of network attributes
\code{net_attr}, and returns a \code{networkLite} object, which is a named list with
fields \code{el}, \code{attr}, and \code{gal}, corresponding to the arguments \code{x}, \code{attr},
and \code{net_attr}. Missing network attributes \code{directed} and \code{bipartite} are
defaulted to \code{FALSE}; the network size attribute \code{n} must not be missing.

The \code{numeric} method takes a number \code{x} as well as the network
attributes \code{directed} and \code{bipartite} (defaulting to \code{FALSE}),
and returns an empty \code{networkLite} with these network attributes and
number of nodes \code{x}.

The constructor \code{networkLite_initialize} is also available for creating
an empty \code{networkLite}, and its \code{x} argument should be a number
indicating the size of the \code{networkLite} to create.

Within \code{EpiModel}, the \code{networkLite} data structure is used in the
calls to \code{ergm} and \code{tergm} \code{simulate} and \code{summary}
functions.
}
\examples{
edgelist <- cbind(c(1, 2, 3), c(2, 4, 7))
attr(edgelist, "n") <- 10 # network size
vertex_attributes <- list(a = 1:10, b = runif(10))
nwL <- networkLite(edgelist, vertex_attributes)
nwL

}
