#The following battery of tests is intended to verify the functionality of
#the network library

library(network)
#These functions are intended to mimic functionality from the sna package.
#Said package is not required to use network, but was used in creating this
#battery of tests.
rgraph<-function(n){
  m<-matrix(rbinom(n*n,1,0.5),n,n)
  diag(m)<-0
  m
}
degree<-function(d,cmode = "freeman")
{
  n <- dim(d)[1]
  diag(d) <- NA
  switch(cmode, indegree = apply(d, 2, sum, na.rm = TRUE),
    outdegree = apply(d, 1, sum, na.rm = TRUE), freeman = apply(d,
    2, sum, na.rm = TRUE) + apply(d, 1, sum, na.rm = TRUE))
}
#gctorture(TRUE)     #Uncomment to perform a more intensive (SLOW) test

#Check assignment, deletion, and adjacency for dyadic graphs
check<-vector()
temp<-network(matrix(0,5,5))
temp[1,2]<-1                 #Add edge
check[1]<-temp[1,2]==1       #Check adjacency
check[2]<-get.network.attribute(temp,"mnext")==2  #Check count
temp[1,2]<-1                 #Should have no effect
check[3]<-get.network.attribute(temp,"mnext")==2  #Check count
temp[1,1]<-1                 #Should have no effect
check[4]<-temp[1,1]==0       #Shouldn't be present
check[5]<-get.network.attribute(temp,"mnext")==2  #Check count
temp[,2]<-1                  #Should add 3 edges
check[6]<-get.network.attribute(temp,"mnext")==5  #Check count
check[7]<-all(temp[,2]==c(1,0,1,1,1))  #Verify row
temp[3:4,3:4]<-1             #Should add 2 edges
check[8]<-get.network.attribute(temp,"mnext")==7  #Check count
temp[,]<-0                   #Delete edges
check[9]<-all(temp[,]==matrix(0,5,5))  #Verify that edges were removed
temp[1:2,3:5]<-1             #Add new edges
check[10]<-sum(temp[,])==6   #Check edge sum
temp<-add.vertices(temp,3)   #Add vertices
check[11]<-network.size(temp)==8
check[12]<-sum(temp[,])==6   #Edges should still be there
check[13]<-all(temp[,5]==c(1,1,0,0,0,0,0,0))
temp[8,]<-1                  #Add edges to new vertex
check[14]<-all(temp[8,]==c(1,1,1,1,1,1,1,0))  #Verify
temp<-delete.vertices(temp,c(7,8))  #Remove vertices
check[15]<-network.size(temp)==6  #Verify removal
check[16]<-sum(temp[,])==6   #Check edge sum
check[17]<-!any(c(7,8)%in%c(sapply(temp$mel,"[[","inl"),sapply(temp$mel,"[[","outl")))  #Make sure they're really gone!
temp<-network(matrix(0,5,5),directed=FALSE,loops=TRUE)  #Create undir graph
check[18]<-is.directed(temp)==FALSE    #Some simple gal tests
check[19]<-has.loops(temp)==TRUE
temp[1,]<-1
check[20]<-all(temp[,1]==temp[1,])   #Verify edges
temp<-permute.vertexIDs(temp,5:1)       #Permute 
check[21]<-all(temp[1,]==c(0,0,0,0,1))  #Verify permutation
check[22]<-all(temp[,5]==rep(1,5))
check[23]<-get.neighborhood(temp,1)==5               #Check neighborhoods
check[24]<-all(sort(get.neighborhood(temp,5))==1:5)
check[25]<-length(get.edges(temp,5))==5            #Check get.edges
check[26]<-length(get.edges(temp,5,2))==1
g<-rgraph(10)
temp<-network(g)
check[27]<-all(g==temp[,])                         #Yet more edge checkage
check[28]<-all(g[3:1,-(4:3)]==temp[3:1,-(4:3)])
temp[,,,names.eval="newval"]<-matrix(1:100,10,10)  #Edge value assignment
check[29]<-all(as.sociomatrix(temp,"newval")==matrix(1:100,10,10)*g)
check[30]<-all(apply(as.matrix.network.incidence(temp),1,sum)==(degree(g,cmode="indegree")-degree(g,cmode="outdegree")))  #Check incidence matrix
check[31]<-all(dim(as.matrix.network.incidence(temp))==c(10,sum(g)))
check[32]<-all(apply(as.matrix.network.incidence(temp,"newval"),1,sum)==(degree(matrix(1:100,10,10)*g,cmode="indegree")-degree(matrix(1:100,10,10)*g,cmode="outdegree")))
check[33]<-all(as.matrix.network.edgelist(temp,"newval")==cbind(row(g)[g>0],col(g)[g>0],matrix(1:100,10,10)[g>0]))
temp[1:3,1:5,names.eval="newval"]<-matrix(1:15,3,5)
check[34]<-all(as.sociomatrix(temp,"newval")[1:3,1:5]==g[1:3,1:5]*matrix(1:15,3,5))
temp[,,"na"]<-TRUE                         #Verify NA filtering
check[35]<-sum(temp[,])==0
check[36]<-sum(is.na(temp[,,na.omit=FALSE]))==sum(g)

#Check assignment, deletion, and adjacency for hypergraphs
temp<-network.initialize(10,directed=F,hyper=T,loops=T)
check[37]<-sum(temp[,])==0
temp<-add.edge(temp,1:4,1:4,"value",list(5))
temp<-add.edge(temp,3:5,3:5,"value",list(6))
temp<-add.edge(temp,4:7,4:7,"value",list(7))
temp<-add.edge(temp,6:10,6:10,"value",list(8))
check[38]<-all(as.matrix.network.incidence(temp)==cbind(c(1,1,1,1,0,0,0,0,0,0),c(0,0,1,1,1,0,0,0,0,0),c(0,0,0,1,1,1,1,0,0,0),c(0,0,0,0,0,1,1,1,1,1)))
check[39]<-all(as.matrix.network.incidence(temp,"value")==cbind(5*c(1,1,1,1,0,0,0,0,0,0),6*c(0,0,1,1,1,0,0,0,0,0),7*c(0,0,0,1,1,1,1,0,0,0),8*c(0,0,0,0,0,1,1,1,1,1)))
check[40]<-all(temp[,]==((as.matrix.network.incidence(temp)%*%t(as.matrix.network.incidence(temp)))>0))

#Check coercion and construction methods
g<-rgraph(10)
temp<-network(g)
check[41]<-all(temp[,]==g)
temp<-as.network(g*matrix(1:100,10,10),names.eval="value",ignore.eval=FALSE)
check[42]<-all(as.sociomatrix(temp,"value")==g*matrix(1:100,10,10))
temp<-as.network.matrix(as.matrix.network.edgelist(temp,"value"),matrix.type="edgelist",names.eval="value",ignore.eval=FALSE)
check[43]<-all(as.sociomatrix(temp,"value")==g*matrix(1:100,10,10))
temp<-as.network.matrix(as.matrix.network.incidence(temp,"value"),matrix.type="incidence",names.eval="value",ignore.eval=FALSE)
check[44]<-all(as.sociomatrix(temp,"value")==g*matrix(1:100,10,10))

#Check attribute assignment/access
g<-rgraph(10)
temp<-network(g)
temp<-set.vertex.attribute(temp,"value",1:10)
check[45]<-all(get.vertex.attribute(temp,"value")==1:10)
temp<-delete.vertex.attribute(temp,"value")
check[46]<-all(is.na(get.vertex.attribute(temp,"value")))
temp<-set.vertex.attribute(temp,"value",1:5,c(2,4,6,8,10))
check[47]<-all(get.vertex.attribute(temp,"value")[c(2,4,6,8,10)]==1:5)
temp<-set.network.attribute(temp,"value","pork!")
check[48]<-get.network.attribute(temp,"value")=="pork!"
temp<-delete.network.attribute(temp,"value")
check[49]<-is.null(get.network.attribute(temp,"value"))
temp<-set.edge.attribute(temp,"value",5)
check[50]<-all(get.edge.attribute(temp$mel,"value")==5)
temp<-delete.edge.attribute(temp,"value")
check[51]<-all(is.null(get.edge.attribute(temp$mel,"value")))
temp<-set.edge.value(temp,"value",g*matrix(1:100,10,10))
check[52]<-all(get.edge.value(temp,"value")==(g*matrix(1:100,10,10))[g>0])
check[53]<-all(as.sociomatrix(temp,"value")==(g*matrix(1:100,10,10)))

#Check additional operators
g<-rgraph(10)
temp<-network(g,names.eval="value",ignore.eval=FALSE)
temp2<-network(g*2,names.eval="value",ignore.eval=FALSE)
check[54]<-all(g==as.sociomatrix(temp+temp2))
check[55]<-all(g*3==as.sociomatrix("+"(temp,temp2,"value"),"value"))
check[56]<-all(g==as.sociomatrix(temp*temp2))
check[57]<-all(g*2==as.sociomatrix("*"(temp,temp2,"value"),"value"))
check[58]<-all(0==as.sociomatrix(temp-temp2))
check[59]<-all(-g==as.sociomatrix("-"(temp,temp2,"value"),"value"))
check[60]<-all(((g%*%g)>0)==as.sociomatrix("%c%.network"(temp,temp2)))
check[61]<-all(((g%*%g)>0)==as.sociomatrix(temp%c%temp2))
check[62]<-all(((!temp)[,]==!g)[diag(10)<1])
check[63]<-all((temp|temp2)[,]==g)
check[64]<-all((temp&temp2)[,]==g)
temp%v%"value"<-1:10
check[65]<-all(temp%v%"value"==1:10)
temp%n%"value"<-"pork!"
check[66]<-temp%n%"value"=="pork!"

#If everything worked, check is TRUE
all(check)                                               #Should be TRUE

