% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcomplex.R
\name{netcomplex}
\alias{netcomplex}
\alias{print.netcomplex}
\title{Calculate effect of arbitrary complex interventions in component
network meta-analysis}
\usage{
netcomplex(
  x,
  complex,
  fixed = x$fixed,
  random = x$random,
  level = x$level.ma,
  nchar.comps = x$nchar.trts
)

\method{print}{netcomplex}(
  x,
  fixed = x$fixed,
  random = x$random,
  backtransf = x$backtransf,
  nchar.comps = x$nchar.comps,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = gs("digits.pval"),
  scientific.pval = gs("scientific.pval"),
  zero.pval = gs("zero.pval"),
  JAMA.pval = gs("JAMA.pval"),
  big.mark = gs("big.mark"),
  legend = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netcomb} or \code{netcomplex}
(print function).}

\item{complex}{A matrix, vector or single numeric defining the
complex intervention(s) (see Details).}

\item{fixed}{A logical indicating whether results for fixed effects
/ common effects model should be conducted.}

\item{random}{A logical indicating whether results for random
effects model should be conducted.}

\item{level}{The level used to calculate confidence intervals for
combinations of components.}

\item{nchar.comps}{A numeric defining the minimum number of
characters used to create unique names for components (see
Details).}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf=TRUE}, results
for \code{sm="OR"} are printed as odds ratios rather than log
odds ratios.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z-value
of test for overall effect, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for
p-values, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{zero.pval}{A logical specifying whether p-values should be
printed with a leading zero.}

\item{JAMA.pval}{A logical specifying whether p-values for test of
combination effect should be printed according to JAMA reporting
standards.}

\item{big.mark}{A character used as thousands separator.}

\item{legend}{A logical indicating whether a legend should be
printed.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A list is returned by the function \code{netcomplex} with the
following elements:
\item{complex}{Complex intervention(s).}
\item{Comb.fixed, Comb.random}{A vector of combination effects
  (fixed and random effects model).}
\item{seComb.fixed, seComb.random}{A vector with corresponding
  standard errors (fixed and random effects model).}
\item{lower.Comb.fixed, lower.Comb.random}{A vector with lower
  confidence limits for combinations (fixed and random effects
  model).}
\item{upper.Comb.fixed, upper.Comb.random}{A vector with upper
  confidence limits for combinations (fixed and random effects
  model).}
\item{statistic.Comb.fixed, statistic.Comb.random}{A vector with
  z-values for the overall effect of combinations (fixed and random
  effects model).}
\item{pval.Comb.fixed, pval.Comb.random}{A vector with p-values for
  the overall effect of combinations (fixed and random effects
  model).}
\item{fixed, random}{A defined above.}
\item{level, nchar.comps, backtransf, x}{A defined above.}
\item{C.matrix}{C matrix.}
}
\description{
Calculate effect of arbitrary complex interventions (i.e.,
combinations of several components) in component network
meta-analysis.
}
\details{
R functions \code{\link{netcomb}} and \code{\link{discomb}} only
report results for complex interventions present in the
network. This function can be used to calculate the effect for
arbitrary complex interventions.

Complex interventions can be specified using argument \code{complex}:
\itemize{
\item a character vector with definition of complex interventions,
\item a single numeric defining the number of components to combine
  in a complex intervention,
\item a dedicated C matrix.
}
In order to calculate effects of arbitrary complex interventions, a
C matrix is needed which describes how the complex interventions
are composed by the components (Rücker et al., 2020, Section
3.2). The C matrix is constructed internally if not provided by
argument \code{complex}. All complex interventions occuring in the
network are considered if argument \code{complex} is missing.

By default, component names are not abbreviated in
printouts. However, in order to get more concise printouts,
argument \code{nchar.comps} can be used to define the minimum
number of characters for abbreviated component names (see
\code{\link{abbreviate}}, argument \code{minlength}). R function
\code{\link{treats}} is utilised internally to create abbreviated
component names.
}
\note{
R function \code{\link{netcomparison}} can be used to calculate the
effect for comparisons of two arbitrary complex intervention in a
component network meta-analysis.
}
\examples{
data(Linde2016)

# Only consider studies including Face-to-face PST (to reduce
# runtime of example)
#
face <- subset(Linde2016, id \%in\% c(16, 24, 49, 118))

# Conduct random effects network meta-analysis
#
net1 <- netmeta(lnOR, selnOR, treat1, treat2, id,
                data = face, ref = "placebo",
                sm = "OR", fixed = FALSE)

# Additive model for treatment components (with placebo as inactive
# treatment)
#
nc1 <- netcomb(net1, inactive = "placebo")

# Result for combination Face-to-face PST + SSRI
netcomplex(nc1, "Face-to-face PST + SSRI", nchar.comps = 4)
netcomplex(nc1, "F + S", nchar.comps = 4)

# Result for combination Face-to-face PST + SSRI + Placebo
netcomplex(nc1, "Face-to-face PST + SSRI + Plac", nchar.comps = 4)

\dontrun{
# Artificial example
t1 <- rep("A", 3)
t2 <- c("B+C", "A+C", "C+D")
TE <- c(0, 1, 0)
seTE <- rep(1, 3)
# Conduct (C)NMA
net2 <- netmeta(TE, seTE, t1, t2, random = FALSE)
nc2 <- netcomb(net2)

# Result for combination A + B + C
netcomplex(nc2, "A + B + C")
# Same results
netcomplex(nc2, "A+B+C")
netcomplex(nc2, "B+C+A")
netcomplex(nc2, "C+B+A")
netcomplex(nc2, "c+b+a")

# Generated C matrix
netcomplex(nc2, c(LETTERS[1:4], "A+B+C"))$C.matrix

# Results for all possible combinations of two components
netcomplex(nc2, 2)
# Results for all possible combinations of three components
netcomplex(nc2, 3)
}

}
\references{
Rücker G, Petropoulou M, Schwarzer G (2020):
Network meta-analysis of multicomponent interventions.
\emph{Biometrical Journal},
\bold{62}, 808--21
}
\seealso{
\code{\link{netcomb}}, \code{\link{discomb}},
  \code{\link{netcomparison}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
