% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.netmeta.R
\name{forest.netmeta}
\alias{forest.netmeta}
\title{Forest plot for network meta-analysis}
\usage{
\method{forest}{netmeta}(
  x,
  pooled = ifelse(x$comb.random, "random", "fixed"),
  reference.group = x$reference.group,
  baseline.reference = x$baseline.reference,
  labels = x$trts,
  equal.size = TRUE,
  leftcols = "studlab",
  leftlabs,
  rightcols = c("effect", "ci"),
  rightlabs,
  digits = gs("digits.forest"),
  small.values = x$small.values,
  digits.Pscore = 2,
  smlab = NULL,
  sortvar = x$seq,
  backtransf = x$backtransf,
  lab.NA = ".",
  add.data,
  drop.reference.group = FALSE,
  col.by = "black",
  print.byvar = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{netmeta}.}

\item{pooled}{A character string indicating whether results for the
fixed effect (\code{"fixed"}) or random effects model
(\code{"random"}) should be plotted. Can be abbreviated.}

\item{reference.group}{Reference treatment(s).}

\item{baseline.reference}{A logical indicating whether results
should be expressed as comparisons of other treatments versus the
reference treatment (default) or vice versa.}

\item{labels}{An optional vector with treatment labels.}

\item{equal.size}{A logical indicating whether all squares should
be of equal size. Otherwise, the square size is proportional to
the precision of estimates.}

\item{leftcols}{A character vector specifying columns to be plotted
on the left side of the forest plot or a logical value (see
Details).}

\item{leftlabs}{A character vector specifying labels for
(additional) columns on left side of the forest plot (see
Details).}

\item{rightcols}{A character vector specifying columns to be
plotted on the right side of the forest plot or a logical value
(see Details).}

\item{rightlabs}{A character vector specifying labels for
(additional) columns on right side of the forest plot (see
Details).}

\item{digits}{Minimal number of significant digits for treatment
effects and confidence intervals, see \code{print.default}.}

\item{small.values}{A character string specifying whether small
treatment effects indicate a beneficial (\code{"good"}) or
harmful (\code{"bad"}) effect, can be abbreviated; see
\code{\link{netrank}}.}

\item{digits.Pscore}{Minimal number of significant digits for
P-score, see \code{\link{print.default}} and
\code{\link{netrank}}.}

\item{smlab}{A label printed at top of figure. By default, text
indicating either fixed effect or random effects model is
printed.}

\item{sortvar}{An optional vector used to sort the individual
studies (must be of same length as the total number of
treatments).}

\item{backtransf}{A logical indicating whether results should be
back transformed in forest plots. If \code{backtransf = TRUE},
results for \code{sm = "OR"} are presented as odds ratios rather
than log odds ratios, for example.}

\item{lab.NA}{A character string to label missing values.}

\item{add.data}{An optional data frame with additional columns to
print in forest plot (see Details).}

\item{drop.reference.group}{A logical indicating whether the
reference group should be printed in the forest plot.}

\item{col.by}{The colour to print information on subgroups.}

\item{print.byvar}{A logical indicating whether the name of the
grouping variable should be printed in front of the group labels.}

\item{\dots}{Additional arguments for \code{\link{forest.meta}}
function.}
}
\description{
Draws a forest plot in the active graphics window (using grid
graphics system).
}
\details{
A forest plot, also called confidence interval plot, is drawn in
the active graphics window.

Argument \code{sortvar} can be either a numeric or character vector
with length of number of treatments. If \code{sortvar} is numeric
the \code{\link[base]{order}} function is utilised internally to
determine the order of values. If \code{sortvar} is character it
must be a permutation of the treatment names. It is also possible
to provide either \code{sortvar = Pscore}, \code{sortvar =
"Pscore"}, \code{sortvar = -Pscore}, or \code{sortvar = "-Pscore"}
in order to sort treatments according to the ranking generated by
\code{\link{netrank}} which is called internally.  Similar
expressions are possible to sort by treatment comparisons
(\code{sortvar = TE}, etc.), standard error (\code{sortvar =
seTE}), number of studies with direct treatment comparisons
(\code{sortvar = k}), and direct evidence proportion (\code{sortvar
= prop.direct}, see also \code{\link{netmeasures}}).

The arguments \code{leftcols} and \code{rightcols} can be used to
specify columns which are plotted on the left and right side of the
forest plot, respectively. The following columns are available:
\tabular{ll}{
\bold{Name} \tab \bold{Definition} \cr
\code{"studlab"} \tab Treatments \cr
\code{"TE"} \tab Network estimates (either from fixed or random
  effects model) \cr
\code{"seTE"} \tab Corresponding standard errors \cr
\code{"Pscore"} \tab P-scores (see \code{\link{netrank}}) \cr
\code{"k"} \tab Number of studies in pairwise comparisons \cr
\code{"prop.direct"} \tab Direct evidence proportions (see
  \code{\link{netmeasures}}) \cr
\code{"effect"} \tab (Back-transformed) network estimates \cr
\code{"ci"} \tab Confidence intervals \cr
\code{"effect.ci"} \tab (Back-transformed) network estimates and
  confidence intervals
}

As a sidenote, the rather odd column name \code{"studlab"} to
describe the treatment comparisons comes from internally calling
\code{\link{forest.meta}} which uses study labels as the essential
information.

Argument \code{add.data} can be used to add additional columns to
the forest plot. This argument must be a data frame with row names
equal to the treatment names in R object \code{x}, i.e.,
\code{x$trts}.

See help page of \code{\link{forest.meta}} for more information on
the generation of forest plots and additional arguments.
}
\examples{
data(Senn2013)

\dontrun{
# Conduct network meta-analysis
#
net1 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD")

forest(net1, ref = "plac")
forest(net1, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference", rightcols = FALSE)
}

# Random effects effect model
#
net2 <- netmeta(TE, seTE, treat1, treat2, studlab,
                data = Senn2013, sm = "MD", comb.fixed = FALSE)

forest(net2, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference")

\dontrun{
# Add column with P-Scores on right side of forest plot
#
forest(net2, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference",
       rightcols = c("effect", "ci", "Pscore"),
       just.addcols = "right")

# Add column with P-Scores on left side of forest plot
#
forest(net2, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference",
       leftcols = c("studlab", "Pscore"),
       just.addcols = "right")

# Sort forest plot by descending P-Score
#
forest(net2, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference",
       rightcols = c("effect", "ci", "Pscore"),
       just.addcols = "right",
       sortvar = -Pscore)

# Drop reference group and sort by and print number of studies with
# direct treatment comparisons
#
forest(net2, xlim = c(-1.5, 1), ref = "plac",
       xlab = "HbA1c difference",
       leftcols = c("studlab", "k"),
       leftlabs = c("Contrast\nto Placebo", "Direct\nComparisons"),
       sortvar = -k,
       drop = TRUE,
       smlab = "Random Effects Model")
}

}
\seealso{
\code{\link{forest.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{hplot}
