% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netmatch.r
\name{netmatch}
\alias{netmatch}
\alias{netmatch_prepare}
\title{Matching Estimators with Network Data}
\usage{
netmatch_prepare(
  dat,
  graph,
  timevar,
  depvar,
  covariates,
  treat_thr = rep(1L, length(graph)),
  adopt_thr = rep(1L, length(graph)),
  expo_pcent = FALSE,
  expo_lag = 0L
)

netmatch(
  dat,
  graph,
  timevar,
  depvar,
  covariates,
  treat_thr = rep(1L, length(graph)),
  adopt_thr = rep(1L, length(graph)),
  expo_pcent = FALSE,
  expo_lag = 0L,
  ...
)
}
\arguments{
\item{dat}{\code{data.frame} with dynamic data. Must be of
\code{nrow(dat)==nslices(graph)*nnodes(graph)}.}

\item{graph}{List with sparse matrices.}

\item{timevar}{Character scalar. Name of time variable}

\item{depvar}{Character scalar. Name of the dependent variable}

\item{covariates}{Character vector. Name(s) of the control variable(s).}

\item{treat_thr}{Either a numeric scalar or vector of length \code{nslices(graph)}.
Sets the threshold of \code{exposure} at which it is considered that an
observation is treated.}

\item{adopt_thr}{Either a numeric scalar or vector of length \code{nslices(graph)}.
Sets the threshold of \code{depvar} at which it is considered that an observation
has adopted a behavior.}

\item{expo_pcent}{Logical scalar. When \code{TRUE}, exposure is computed
non-normalized (so it is a count rather than a percentage).}

\item{expo_lag}{Integer scalar. Number of lags to consider when computing
exposure. \code{expo_lag=1} defines exposure in T considering behavior and
network at T-1.}

\item{...}{Further arguments to be passed to \code{\link[MatchIt:matchit]{matchit}}.}
}
\value{
In the case of \code{netmatch_prepare}
\item{dat}{A \code{data.frame} with the original data (covariates), plus the
following new variables: \code{treat}, \code{adopt}, \code{exposure}.
}
\item{match_model}{A formula to be passed to \code{netmatch}}

\code{netmatch} returns the following:
\item{fATT}{A numeric vector of length \eqn{N_1}{N1} (number of treated used
in the matching process). Treatment effects on the treated at the individual
level}
\item{match_obj}{The output from \code{matchit}.}
}
\description{
\strong{WARNING}: This function is still in development and has not been tested throughly.
Following Aral et al. (2009), \code{netmatch} computes matching
estimators for network data. The function \code{netmatch_prepare}, which
prepares the data to be used with \code{\link[MatchIt:matchit]{matchit}} from
the \pkg{\link[MatchIt:MatchIt]{MatchIt}} package, is called by \code{netmatch}.
}
\details{
In Aral et al. (2009), the matching estimator is used as a response to the
fact that the observed network is homophilous. Essentially, using exposure
as a treatment indicator, which is known to be endogenous, we can apply the
same principle of matching estimators in which, after controlling for characteristics
(covariates), individuals from the treated group (exposed to some behavior)
can be compared to individuals from the control group (not exposed to that
behavior), as the only difference between the two is the exposure.

As pointed out in King & Nielsen (2015), it is suggested that, contrary to
what Aral et al. (2009), the matching is not performed over propensity score
since it is know that the later can increase imbalances in the data and thus
obtaining exactly the opposed outcome that matching based estimators pursue.

A couple of good references for matching estimators are Imbens and Wooldridge
(2009), and Sekhon (2008).
}
\references{
Aral, S., Muchnik, L., & Sundararajan, A. (2009). Distinguishing
influence-based contagion from homophily-driven diffusion in dynamic networks.
Proceedings of the National Academy of Sciences of the United States of America,
106(51), 21544–21549. \doi{10.1073/pnas.0908800106}

Imbens, G. W., & Wooldridge, J. M. (2009). Recent Developments in the
Econometrics of Program Evaluation. Journal of Economic Literature, 47(1),
5–86. \doi{10.1257/jel.47.1.5}

King, G., & Nielsen, R. (2015). Why Propensity Scores Should Not Be Used for.

Sekhon, J. S. (2008). The Neyman-Rubin Model of Causal Inference and Estimation
Via Matching Methods. The Oxford Handbook of Political Methodology.
\doi{10.1093/oxfordhb/9780199286546.003.0011}
}
\author{
George G. Vega Yon
}
