% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_diffnet2.r
\name{round_to_seq}
\alias{round_to_seq}
\title{Takes a numeric vector and maps it into a finite length sequence}
\usage{
round_to_seq(x, nlevels = 20, as_factor = FALSE)
}
\arguments{
\item{x}{A numeric or integer vector.}

\item{nlevels}{Integer scalar. Length of the sequence to be map onto.}

\item{as_factor}{Logical scalar. When \code{TRUE} the resulting vector is factor.}
}
\value{
A vector of length \code{length(x)} with values mapped to a sequence
with \code{nlevels} unique valuess
}
\description{
Takes a numeric vector and maps it into a finite length sequence
}
\examples{

x <- rnorm(100)
w <- data.frame(as.integer(round_to_seq(x, as_factor = TRUE)),x)
plot(w,x)

}
\seealso{
Used in \code{\link{diffmap}} and \code{\link{plot_diffnet2}}
}
