% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestedHypotheses.R
\name{nestedHypotheses}
\alias{nestedHypotheses}
\alias{Anova.nestedLogit}
\alias{print.Anova.nestedLogit}
\alias{anova.nestedLogit}
\alias{print.anova.nestedLogit}
\alias{logLik.nestedLogit}
\alias{linearHypothesis.nestedLogit}
\title{Hypothesis-Testing and Related Methods for \code{"nestedLogit"} Objects}
\usage{
\method{Anova}{nestedLogit}(mod, ...)

\method{print}{Anova.nestedLogit}(x, ...)

\method{linearHypothesis}{nestedLogit}(model, ...)

\method{anova}{nestedLogit}(object, object2, ...)

\method{print}{anova.nestedLogit}(x, ...)

\method{logLik}{nestedLogit}(object, ...)
}
\arguments{
\item{\dots}{arguments to be passed down. In the case of \code{linearHypothesis},
the second argument is typically the \code{hypothesis.matrix}. See the
Details section of \code{\link[car]{linearHypothesis}}. In the case of \code{anova},
additional sequential \code{"nestedLogit"} models.}

\item{x, object, object2, mod, model}{in most cases, an object of class \code{"nestedLogit"}.}
}
\value{
\itemize{
\item The \code{Anova} and \code{anova} methods return objects
of class \code{"Anova.nestedLogit"} and \code{"anova.nestedLogit"}, respectively,
each of which contains a list of \code{"anova"} objects (see \code{\link{anova}})
and is usually printed.
\item The \code{linearHypothesis} method is called for its side effect, printing
the result of linear hypothesis tests, and invisibly returns \code{NULL}.
\item The \code{logLik} method returns an object of class \code{"logLik"} (see \code{\link{logLik}}).
}
}
\description{
Various methods for testing hypotheses about nested logit models.
\describe{
\item{\code{Anova}}{Calculates type-II or type-III analysis-of-variance tables for \code{"nestedLogit"} objects;
see \code{\link[car]{Anova}} in the \pkg{car} package.}
\item{\code{anova}}{Computes sequential analysis of variance (or deviance) tables for one or more fitted
\code{"nestedLogit"}  objects; see \code{\link{anova}}.}
\item{\code{linearHypothesis}}{Computes Wald tests for linear hypotheses;
see \code{\link[car]{linearHypothesis}} in the \pkg{car} package.}
\item{\code{logLik}}{Returns the log-likelihood and degrees of freedom for the nested-dichotomies model.
(and through it \code{\link{AIC}} and \code{\link{BIC}} model-comparison statistics).}
}
}
\examples{
# define continuation dichotomies for level of education
cont.dichots <- continuationLogits(c("l.t.highschool",
                                     "highschool",
                                     "college",
                                     "graduate"))
# fit a nested model for the GSS data examining education degree in relation to parent & year
m <- nestedLogit(degree ~ parentdeg + year,
                 cont.dichots,
                 data=GSS)

# Anova and anova tests
car::Anova(m) # type-II (partial) tests

anova(update(m, . ~ . - year), m) # model comparison

# Wald test
car::linearHypothesis(m, c("parentdeghighschool", "parentdegcollege",
                           "parentdeggraduate"))

# log-liklihood, AIC, and BIC
logLik(m)
AIC(m)
BIC(m)
}
\seealso{
\code{\link[car]{Anova}}, \code{\link{anova}},
\code{\link[car]{linearHypothesis}}, \code{\link{logLik}}, \code{\link{AIC}},
\code{\link{BIC}}
}
\author{
John Fox
}
\keyword{regression}
