% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_08.R
\name{trauma_08}
\alias{trauma_08}
\title{Trauma-08 Calculation}
\usage{
trauma_08(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  disposition_table = NULL,
  vitals_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  transport_disposition_col,
  evitals_06_col,
  evitals_14_col,
  evitals_23_col,
  confidence_interval = FALSE,
  method = c("wilson", "clopper-pearson"),
  conf.level = 0.95,
  correct = TRUE,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data with all relevant
columns. Default is \code{NULL}.}

\item{patient_scene_table}{A data frame or tibble containing only epatient
and escene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data frame or tibble containing only the eresponse
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data frame or tibble containing only the esituation
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{disposition_table}{A data frame or tibble containing only the
edisposition fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data frame or tibble containing only the evitals fields
needed for this measure's calculations. Default is \code{NULL}.}

\item{erecord_01_col}{A column specifying unique patient records.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{A column indicating the patient’s age in numeric form.}

\item{epatient_16_col}{A column specifying the unit of patient age (e.g.,
"Years", "Days").}

\item{esituation_02_col}{A column containing information about the nature of
the patient’s condition (e.g., injury type).}

\item{eresponse_05_col}{A column specifying the type of response (e.g., 911
codes).}

\item{transport_disposition_col}{A column specifying transport disposition
for the patient.}

\item{evitals_06_col}{A column containing systolic blood pressure (SBP) data
from initial vital signs.}

\item{evitals_14_col}{A column containing respiratory rate data from initial
vital signs.}

\item{evitals_23_col}{A column containing total Glasgow Coma Scale (GCS)
scores from initial vital signs.}

\item{confidence_interval}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Logical. If
\code{TRUE}, the function calculates a confidence interval for the proportion
estimate.}

\item{method}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Character. Specifies the
method used to calculate confidence intervals. Options are \code{"wilson"}
(Wilson score interval) and \code{"clopper-pearson"} (exact binomial interval).
Partial matching is supported, so \code{"w"} and \code{"c"} can be used as shorthand.}

\item{conf.level}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Numeric. The confidence
level for the interval, expressed as a proportion (e.g., 0.95 for a 95\%
confidence interval). Defaults to 0.95.}

\item{correct}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}Logical. If \code{TRUE},
applies a continuity correction to the Wilson score interval when \code{method = "wilson"}. Defaults to \code{TRUE}.}

\item{...}{optional additional arguments to pass onto \code{dplyr::summarize}.}
}
\value{
A data.frame summarizing results for two population groups (All,
Adults and Peds) with the following columns:
\itemize{
\item \code{pop}: Population type (All, Adults, and Peds).
\item \code{numerator}: Count of incidents meeting the measure.
\item \code{denominator}: Total count of included incidents.
\item \code{prop}: Proportion of incidents meeting the measure.
\item \code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
\item \code{lower_ci}: Lower bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
\item \code{upper_ci}: Upper bound of the confidence interval for \code{prop}
(if \code{confidence_interval = TRUE}).
}
}
\description{
This function calculates the Trauma-08 measure, which evaluates the
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    esituation_02 = rep("Yes", 5),
    evitals_06 = c(100, 90, 80, 70, 85),
    evitals_14 = c(30, 9, 8, 7, 31),
    evitals_23 = c(6, 7, 8, 8, 7),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007)
  )

  # Run function with the first and last pain score columns
  # Return 95\% confidence intervals using the Wilson method
  trauma_08(
    df = test_data,
    erecord_01_col = erecord_01,
    incident_date_col = NULL,
    patient_DOB_col = NULL,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    esituation_02_col = esituation_02,
    evitals_06_col = evitals_06,
    evitals_14_col = evitals_14,
    evitals_23_col = evitals_23,
    transport_disposition_col = edisposition_30,
    confidence_interval = TRUE
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
