% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_percent.r
\name{pretty_percent}
\alias{pretty_percent}
\title{Format Numeric Variables as Percentages}
\usage{
pretty_percent(variable, n_decimal = 1)
}
\arguments{
\item{variable}{A numeric vector representing proportions to format as
percentages. The values are on a scale from 0 to 1.}

\item{n_decimal}{A numeric value specifying the number of decimal places.
Defaults to \code{1}.}
}
\value{
A character vector containing the formatted percentages.
}
\description{
This function formats numeric variables as percentages with a specified
number of decimal places. It refines the output by removing unnecessary
trailing zeros after the decimal point and ensures the percentage sign is
correctly applied without extraneous characters, resulting in a polished,
human-readable percentage representation.
}
\examples{
# Example usage:
pretty_percent(0.12345)  # Default decimal places
pretty_percent(0.12345, n_decimal = 2)  # Two decimal places
pretty_percent(c(0.1, 0.25, 0.3333), n_decimal = 1)  # Vector input

}
\author{
Nicolas Foss, Ed.D., MS
}
