% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCVariable.R
\docType{class}
\name{NCVariable}
\alias{NCVariable}
\title{NetCDF variable}
\description{
This class represents a netCDF variable, the object that holds
the properties and data of elements like dimensions and variables of a
netCDF file.

Direct access to netCDF variables is usually not necessary. NetCDF
variables are linked from CF data variables and axes and all relevant
properties are thus made accessible.
}
\section{Super class}{
\code{\link[ncdfCF:NCObject]{ncdfCF::NCObject}} -> \code{NCVariable}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{group}}{(read-only) NetCDF group where this variable is located.}

\item{\code{vtype}}{(read-only) The netCDF data type of this variable. This could be the
packed type. Don't check this field but use the appropriate method in the
class of the object whose data type you are looking for.}

\item{\code{ndims}}{(read-only) Number of dimensions that this variable uses.}

\item{\code{dimids}}{(read-only) Vector of dimension identifiers that this
NCVariable uses.}

\item{\code{netcdf4}}{(read-only) Additional properties for a \code{netcdf4} resource.}

\item{\code{CF}}{Register CF object that uses this netCDF variable, or retrieve
the list of registered CF objects.}

\item{\code{fullname}}{(read-only) Name of this netCDF variable including the
group path from the root group.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-NCVariable-new}{\code{NCVariable$new()}}
\item \href{#method-NCVariable-print}{\code{NCVariable$print()}}
\item \href{#method-NCVariable-shard}{\code{NCVariable$shard()}}
\item \href{#method-NCVariable-detach}{\code{NCVariable$detach()}}
\item \href{#method-NCVariable-get_data}{\code{NCVariable$get_data()}}
\item \href{#method-NCVariable-dimension}{\code{NCVariable$dimension()}}
\item \href{#method-NCVariable-dim}{\code{NCVariable$dim()}}
\item \href{#method-NCVariable-clone}{\code{NCVariable$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="attribute"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-attribute'><code>ncdfCF::NCObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="print_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-print_attributes'><code>ncdfCF::NCObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="NCObject" data-id="write_attributes"><a href='../../ncdfCF/html/NCObject.html#method-NCObject-write_attributes'><code>ncdfCF::NCObject$write_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-new"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-new}{}}}
\subsection{Method \code{new()}}{
Create a new netCDF variable. This class should not be
instantiated directly, they are created automatically when opening a
netCDF resource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$new(
  id,
  name,
  group,
  vtype,
  dimids,
  attributes = data.frame(),
  netcdf4 = list()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Numeric identifier of the netCDF object.}

\item{\code{name}}{Character string with the name of the netCDF object.}

\item{\code{group}}{The \link{NCGroup} this variable is located in.}

\item{\code{vtype}}{The netCDF data type of the variable.}

\item{\code{dimids}}{The identifiers of the dimensions this variable uses.}

\item{\code{attributes}}{Optional, \code{data.frame} with the attributes of the
object.}

\item{\code{netcdf4}}{Optional, \code{netcdf4}-specific arguments in the format of
RNetCDF.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of this class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-print"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-print}{}}}
\subsection{Method \code{print()}}{
Summary of the NC variable printed to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Passed on to other methods.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-shard"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-shard}{}}}
\subsection{Method \code{shard()}}{
Very concise information on the variable. The information
returned by this function is very concise and most useful when combined
with similar information from other variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$shard()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string with very basic variable information.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-detach"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-detach}{}}}
\subsection{Method \code{detach()}}{
Detach the passed object from this NC variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$detach(obj)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{obj}}{The CFObject instance to detach from this NC variable.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{obj}, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-get_data}{}}}
\subsection{Method \code{get_data()}}{
Read (a chunk of) data from the netCDF file. Degenerate
dimensions are maintained and data is always returned in its smallest
type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$get_data(start = NA, count = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{A vector of indices specifying the element where reading
starts along each dimension of the data. When \code{NA}, all data are read
from the start of the array.}

\item{\code{count}}{An integer vector specifying the number of values to read
along each dimension of the data. Any \code{NA} value in vector count
indicates that the corresponding dimension should be read from the
start index to the end of the dimension.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An array with the requested data, or an error object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-dimension"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-dimension}{}}}
\subsection{Method \code{dimension()}}{
Get the \link{NCDimension} object(s) that this variable uses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$dimension(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The index of the dimension. If missing, all dimensions of this
variable are returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{NCDimension} object or a list thereof. If no \code{NCDimension}s
were found, return \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-dim"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-dim}{}}}
\subsection{Method \code{dim()}}{
The lengths of the data dimensions of this object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$dim(dimension)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dimension}}{Optional. The index of the dimension to retrieve the
length for. If omitted, retrieve the lengths of all dimensions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-NCVariable-clone"></a>}}
\if{latex}{\out{\hypertarget{method-NCVariable-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{NCVariable$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
