\name{var_args_list}
\alias{var_args_list}
\title{var args list}
\description{Parse the variable-length argument list used in \code{\link{capture_first_vec}},
\code{\link{capture_first_df}}, and \code{\link{capture_all_str}}. This function is mostly
intended for internal use, but is useful if you want to see the
regex pattern generated by the variable argument syntax.}
\usage{var_args_list(..., type.convert = getOption("nc.type.convert", 
    FALSE))}
\arguments{
  \item{\dots}{character vectors (for regex patterns) or functions (which specify
how to convert extracted character vectors to other types). All
patterns must be character vectors of length 1. If the pattern is
a named argument in R, it becomes a capture \code{\link{group}} in the regex
pattern. All patterns are pasted together to obtain the final
pattern used for matching. Each named pattern may be followed by
at most one function which is used to convert the previous named
pattern. Patterns may also be lists, which are parsed recursively
for convenience.}
  \item{type.convert}{Default conversion function, which will be used on each capture
\code{\link{group}}, unless a specific conversion is specified for that
\code{\link{group}}. If TRUE, use \code{\link[utils]{type.convert}}; if FALSE, use
\code{\link[base]{identity}}; otherwise must be a function of at least one
argument (character), returning an atomic vector of the same
length.}
}

\value{a list with two named elements
\item{fun.list}{list of conversion functions with names corresponding to capture group(s)}
\item{pattern}{regular expression string with capture group(s)}}

\author{Toby Hocking <toby.hocking@r-project.org> [aut, cre]}




\examples{

pos.pattern <- list("[0-9]+", as.integer)
nc::var_args_list(
  chrom="chr.*?",
  ":",
  chromStart=pos.pattern,
  list(
    "-",
    chromEnd=pos.pattern
  ), "?")

}
