% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dotprops.R
\name{dotprops}
\alias{as.dotprops}
\alias{dotprops}
\alias{dotprops.character}
\alias{dotprops.default}
\alias{dotprops.dotprops}
\alias{dotprops.im3d}
\alias{dotprops.neuron}
\alias{dotprops.neuronlist}
\alias{is.dotprops}
\title{dotprops: Neurons as point clouds with tangent vectors (but no connectivity)}
\usage{
is.dotprops(x)

as.dotprops(x, ...)

dotprops(x, ...)

\method{dotprops}{character}(x, ...)

\method{dotprops}{dotprops}(x, k = attr(x, "k"), ...)

\method{dotprops}{im3d}(x, ...)

\method{dotprops}{neuronlist}(x, ..., OmitFailures = NA)

\method{dotprops}{neuron}(x, Labels = NULL, resample = NA, ...)

\method{dotprops}{default}(x, k = NULL, Labels = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{Object to be tested/converted}

\item{...}{Additional arguments passed to methods}

\item{k}{Number of nearest neighbours to use for tangent vector calculation
(set to k=20 when passed NULL)}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an
error. The default value (\code{NA}) will result in nlapply stopping with
an error message the moment there is an eror. For other values, see
details.}

\item{Labels}{Vector of labels for each point or \code{NULL} to accept
class-specific default behaviour for different S3 classes, \code{TRUE}
always to use labels when incoming object has them and \code{FALSE} never
to use labels.}

\item{resample}{When finite, a new length to which all segmented edges will
be resampled. See \code{\link{resample.neuron}}.}

\item{na.rm}{Whether to remove \code{NA} points (default FALSE)}
}
\description{
dotprops: Neurons as point clouds with tangent vectors (but no connectivity)

\code{dotprops} makes dotprops representation from raw 3D points
  (extracting vertices from S3 objects that have them)

\code{dotprops.dotprops} will default to the original vale of
  \code{k} and copy over all attributes that are not set by
  \code{dotprops.default}.

\code{dotprops.neuronlist} will run for every object in the
  neuronlist using \code{\link{nlapply}}. \code{...} arguments will be passed to
  \code{nlapply} in addition to the named argument \code{OmitFailures}.
}
\details{
\code{k} will default to 20 nearest neighbours when unset (i.e. when
  it has default value of NA) unless \code{x} is a dotprops object (when the
  original value of \code{k} is reused).
}
\references{
The dotprops format is essentially identical to that developed in:

Masse N.Y., Cachero S., Ostrovsky A., and Jefferis G.S.X.E. (2012).
A mutual information approach to automate identification of neuronal clusters
in \emph{Drosophila} brain images. Frontiers in Neuroinformatics 6 (00021).
\href{http://dx.doi.org/10.3389/fninf.2012.00021}{doi: 10.3389/fninf.2012.00021}
}
\seealso{
\code{\link{nlapply}}
}

