% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-parquet-schema.R
\name{infer_parquet_schema}
\alias{infer_parquet_schema}
\title{Infer Parquet schema of a data frame}
\usage{
infer_parquet_schema(df, options = parquet_options())
}
\arguments{
\item{df}{Data frame.}

\item{options}{Return value of \code{\link[=parquet_options]{parquet_options()}}, may modify the
R to Parquet type mappings.}
}
\value{
Data frame, the inferred schema. It has the same columns as
the return value of \code{\link[=read_parquet_schema]{read_parquet_schema()}}:
\code{file_name}, \code{name}, \code{r_type}, \code{type}, \code{type_length}, \code{repetition_type}, \code{converted_type}, \code{logical_type}, \code{num_children}, \code{scale}, \code{precision}, \code{field_id}.
}
\description{
Infer Parquet schema of a data frame
}
\seealso{
\code{\link[=read_parquet_schema]{read_parquet_schema()}} to read the schema of a Parquet file,
\code{\link[=parquet_schema]{parquet_schema()}} to create a Parquet schema from scratch.
}
