% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-common-na-numbers.R
\docType{data}
\name{common_na_numbers}
\alias{common_na_numbers}
\title{Common number values for NA}
\format{
An object of class \code{numeric} of length 8.
}
\usage{
common_na_numbers
}
\description{
This vector contains common number values of NA (missing), which is aimed to
be used inside naniar functions \code{\link[=miss_scan_count]{miss_scan_count()}} and
\code{\link[=replace_with_na]{replace_with_na()}}. The current list of numbers can be found by printing
out \code{common_na_numbers}. It is a useful way to explore your data for
possible missings, but I strongly warn against using this to replace NA
values without very carefully looking at the incidence for each of the
cases. Common NA strings are in the data object \code{common_na_strings}.
}
\note{
original discussion here \url{https://github.com/njtierney/naniar/issues/168}
}
\examples{

dat_ms <- tibble::tribble(~x,  ~y,    ~z,
                          1,   "A",   -100,
                          3,   "N/A", -99,
                          NA,  NA,    -98,
                          -99, "E",   -101,
                          -98, "F",   -1)

miss_scan_count(dat_ms, -99)
miss_scan_count(dat_ms, c("-99","-98","N/A"))
common_na_numbers
miss_scan_count(dat_ms, common_na_numbers)
}
\keyword{datasets}
