% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-fct.R
\name{gg_miss_fct}
\alias{gg_miss_fct}
\title{Plot the number of missings for each variable, broken down by a factor}
\usage{
gg_miss_fct(x, fct)
}
\arguments{
\item{x}{data.frame}

\item{fct}{column containing the factor variable to visualise}
}
\value{
ggplot object depicting the \% missing of each factor level for
each variable.
}
\description{
This function draws a ggplot plot of the number of missings in each column,
broken down by a categorical variable from the dataset. A default minimal
theme is used, which can be customised as normal for ggplot.
}
\examples{

gg_miss_fct(x = riskfactors, fct = marital)
library(ggplot2)
gg_miss_fct(x = riskfactors, fct = marital) + labs(title = "NA in Risk Factors and Marital status")


}
\seealso{
\code{\link[=geom_miss_point]{geom_miss_point()}} \code{\link[=gg_miss_case]{gg_miss_case()}} \link{gg_miss_case_cumsum} \code{\link[=gg_miss_span]{gg_miss_span()}} \code{\link[=gg_miss_var]{gg_miss_var()}} \code{\link[=gg_miss_var_cumsum]{gg_miss_var_cumsum()}} \code{\link[=gg_miss_which]{gg_miss_which()}}
}
