% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miss-x-summary.R
\name{miss_case_summary}
\alias{miss_case_summary}
\title{Summarise the missingness in each case}
\usage{
miss_case_summary(data, order = TRUE, add_cumsum = FALSE, ...)
}
\arguments{
\item{data}{a data.frame}

\item{order}{a logical indicating whether or not to order the result by
n_miss. Defaults to TRUE. If FALSE, order of cases is the order input.}

\item{add_cumsum}{logical indicating whether or not to add the cumulative
sum of missings to the data. This can be useful when exploring patterns
of nonresponse. These are calculated as the cumulative sum of the missings
in the variables as they are first presented to the function.}

\item{...}{extra arguments}
}
\value{
a tibble of the percent of missing data in each case.
}
\description{
Provide a summary for each case in the data of the number, percent missings,
and cumulative sum of missings of the order of the variables. By default,
it orders by the most missings in each variable.
}
\examples{

# works with group_by from dplyr
library(dplyr)
airquality \%>\%
  group_by(Month) \%>\%
  miss_case_summary()

miss_case_summary(airquality)

}
\seealso{
\code{\link[=pct_miss_case]{pct_miss_case()}} \code{\link[=prop_miss_case]{prop_miss_case()}} \code{\link[=pct_miss_var]{pct_miss_var()}} \code{\link[=prop_miss_var]{prop_miss_var()}} \code{\link[=pct_complete_case]{pct_complete_case()}} \code{\link[=prop_complete_case]{prop_complete_case()}} \code{\link[=pct_complete_var]{pct_complete_var()}} \code{\link[=prop_complete_var]{prop_complete_var()}} \code{\link[=miss_prop_summary]{miss_prop_summary()}} \url{miss_case_summary} \url{miss_case_table} \url{miss_summary} \url{miss_var_prop} \url{miss_var_run} \url{miss_var_span} \url{miss_var_summary} \url{miss_var_table} \url{n_complete} \url{n_complete_row} \url{n_miss} \url{n_miss_row} \url{pct_complete} \url{pct_miss} \url{prop_complete} \url{prop_complete_row} \url{prop_miss}
}
